/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.unit.test;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.unit.test.DocumentFixture;
import com.liferay.portal.search.unit.test.IndexingFixture;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;

public abstract class BaseIndexingTestCase {
    protected static final long COMPANY_ID = RandomTestUtil.randomLong();
    protected static final long GROUP_ID = RandomTestUtil.randomLong();
    private final DocumentFixture _documentFixture = new DocumentFixture();
    private final String _entryClassName;
    private IndexingFixture _indexingFixture;
    private IndexSearcher _indexSearcher;
    private IndexWriter _indexWriter;

    public BaseIndexingTestCase() {
        Class<?> clazz = this.getClass();
        this._entryClassName = StringUtil.toLowerCase((String)clazz.getSimpleName());
    }

    @Before
    public void setUp() throws Exception {
        this._documentFixture.setUp();
        this._indexingFixture = this.createIndexingFixture();
        Assume.assumeTrue(this._indexingFixture.isSearchEngineAvailable());
        this._indexingFixture.setUp();
        this._indexSearcher = this._indexingFixture.getIndexSearcher();
        this._indexWriter = this._indexingFixture.getIndexWriter();
    }

    @After
    public void tearDown() throws Exception {
        if (!this._indexingFixture.isSearchEngineAvailable()) {
            return;
        }
        this._documentFixture.tearDown();
        this._indexWriter.deleteEntityDocuments(BaseIndexingTestCase.createSearchContext(), this._entryClassName);
        this._indexingFixture.tearDown();
    }

    protected static SearchContext createSearchContext() {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(COMPANY_ID);
        searchContext.setEnd(-1);
        searchContext.setGroupIds(new long[]{GROUP_ID});
        QueryConfig queryConfig = new QueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setHitsProcessingEnabled(true);
        queryConfig.setScoreEnabled(false);
        searchContext.setQueryConfig(queryConfig);
        searchContext.setStart(-1);
        return searchContext;
    }

    protected void addDocument(DocumentCreationHelper documentCreationHelper) throws Exception {
        Document document = DocumentFixture.newDocument(COMPANY_ID, GROUP_ID, this._entryClassName);
        documentCreationHelper.populate(document);
        this._indexWriter.addDocument(BaseIndexingTestCase.createSearchContext(), document);
    }

    protected abstract IndexingFixture createIndexingFixture() throws Exception;

    protected Hits search(SearchContext searchContext) throws Exception {
        TermQueryImpl query = new TermQueryImpl("entryClassName", this._entryClassName);
        return this._indexSearcher.search(searchContext, (Query)query);
    }

    public static interface DocumentCreationHelper {
        public void populate(Document var1);
    }
}

