/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow.test;

import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.test.WorkflowHandlerReplacer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkflowHandlerInvocationCounter<T>
implements AutoCloseable {
    private final Map<Method, AtomicInteger> _counts;
    private final WorkflowHandlerReplacer<T> _workflowHandlerReplacer;

    public WorkflowHandlerInvocationCounter(String className) {
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
        this._counts = new HashMap<Method, AtomicInteger>();
        WorkflowHandler<T> delegateWorkflowHandler = this._createInvocationCounterWorkflowHandler(workflowHandler);
        this._workflowHandlerReplacer = new WorkflowHandlerReplacer<T>(className, delegateWorkflowHandler);
    }

    @Override
    public void close() throws Exception {
        this._workflowHandlerReplacer.close();
    }

    public int getCount(String methodName, Class<?> ... parameterTypes) throws Exception {
        Method method = WorkflowHandler.class.getMethod(methodName, parameterTypes);
        AtomicInteger count = this._counts.get(method);
        if (count == null) {
            return 0;
        }
        return count.get();
    }

    private WorkflowHandler<T> _createInvocationCounterWorkflowHandler(final WorkflowHandler<T> workflowHandler) {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        return (WorkflowHandler)ProxyUtil.newProxyInstance((ClassLoader)classLoader, (Class[])new Class[]{WorkflowHandler.class}, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                AtomicInteger count = (AtomicInteger)WorkflowHandlerInvocationCounter.this._counts.get(method);
                if (count == null) {
                    count = new AtomicInteger();
                    WorkflowHandlerInvocationCounter.this._counts.put(method, count);
                }
                count.incrementAndGet();
                return method.invoke((Object)workflowHandler, args);
            }
        });
    }
}

