/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourceBlockPermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceBlockPermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ResourceBlockPermissionTestUtil {
    public static ResourceBlockPermission addResourceBlockPermission(long resourceBlockId, long roleId, long actionIds) throws Exception {
        long resourceBlockPermissionId = CounterLocalServiceUtil.increment((String)ResourceBlockPermission.class.getName());
        ResourceBlockPermission resourceBlockPermission = ResourceBlockPermissionLocalServiceUtil.createResourceBlockPermission((long)resourceBlockPermissionId);
        resourceBlockPermission.setResourceBlockId(resourceBlockId);
        resourceBlockPermission.setRoleId(roleId);
        resourceBlockPermission.setActionIds(actionIds);
        return ResourceBlockPermissionLocalServiceUtil.addResourceBlockPermission((ResourceBlockPermission)resourceBlockPermission);
    }

    public static void removeResourceBlockPermissions(long companyId, long groupId, String portletResource, String resourceName, long classPK, String[] roleNames, List<String> actionIds) throws PortalException {
        List resourceActionsIds = ResourceActionsUtil.getResourceActions((String)portletResource, (String)resourceName);
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        for (String roleName : roleNames) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
            List roleActionIds = ListUtil.copy((List)resourceActionsIds);
            if (roleName.equals("Guest")) {
                List unsupportedActionIds = ResourceActionsUtil.getResourceGuestUnsupportedActions((String)portletResource, (String)resourceName);
                roleActionIds.removeAll(unsupportedActionIds);
            }
            roleActionIds.removeAll(actionIds);
            roleIdsToActionIds.put(role.getRoleId(), ArrayUtil.toStringArray((Collection)roleActionIds));
        }
        ResourceBlockLocalServiceUtil.setIndividualScopePermissions((long)companyId, (long)groupId, (String)resourceName, (long)classPK, roleIdsToActionIds);
    }
}

