/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class RandomTestUtil {
    private static final int _RANDOMIZER_BUMPER_TRIES_MAX = 100;
    private static final Random _random = new Random();

    public static Date nextDate() {
        return new Date();
    }

    public static double nextDouble() throws Exception {
        return CounterLocalServiceUtil.increment();
    }

    public static int nextInt() throws Exception {
        return (int)CounterLocalServiceUtil.increment();
    }

    public static long nextLong() throws Exception {
        return CounterLocalServiceUtil.increment();
    }

    public static boolean randomBoolean() {
        return _random.nextBoolean();
    }

    @SafeVarargs
    public static byte[] randomBytes(int size, RandomizerBumper<byte[]> ... randomizerBumpers) {
        byte[] bytes = new byte[size];
        block0: for (int i = 0; i < 100; ++i) {
            _random.nextBytes(bytes);
            for (RandomizerBumper<byte[]> randomizerBumper : randomizerBumpers) {
                if (!randomizerBumper.accept(bytes)) continue block0;
            }
            return bytes;
        }
        throw new IllegalStateException("Unable to generate a random byte array that is acceptable by all randomizer bumpers " + Arrays.toString(randomizerBumpers) + " after " + 100 + " tries");
    }

    @SafeVarargs
    public static byte[] randomBytes(RandomizerBumper<byte[]> ... randomizerBumpers) {
        return RandomTestUtil.randomBytes(8, randomizerBumpers);
    }

    public static double randomDouble() {
        double value = _random.nextDouble();
        if (value > 0.0) {
            return value;
        }
        if (value == 0.0) {
            return RandomTestUtil.randomDouble();
        }
        return -value;
    }

    @SafeVarargs
    public static InputStream randomInputStream(RandomizerBumper<byte[]> ... randomizerBumpers) {
        return new UnsyncByteArrayInputStream(RandomTestUtil.randomBytes(randomizerBumpers));
    }

    public static int randomInt() {
        int value = _random.nextInt();
        if (value > 0) {
            return value;
        }
        if (value == 0) {
            return RandomTestUtil.randomInt();
        }
        return -value;
    }

    public static int randomInt(int min, int max) throws IllegalArgumentException {
        if (min < 0 || max < 0) {
            throw new IllegalArgumentException("Both min and max values must be positive");
        }
        if (max < min) {
            throw new IllegalArgumentException("Max value must be greater than the min value");
        }
        int value = _random.nextInt(max - min + 1) + min;
        if (value > 0) {
            return value;
        }
        if (value == 0) {
            return RandomTestUtil.randomInt(min, max);
        }
        return -value;
    }

    public static Map<Locale, String> randomLocaleStringMap() {
        return RandomTestUtil.randomLocaleStringMap(LocaleUtil.getDefault());
    }

    public static Map<Locale, String> randomLocaleStringMap(Locale locale) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        map.put(LocaleUtil.getDefault(), RandomTestUtil.randomString(new RandomizerBumper[0]));
        return map;
    }

    public static long randomLong() {
        long value = _random.nextLong();
        if (value > 0L) {
            return value;
        }
        if (value == 0L) {
            return RandomTestUtil.randomLong();
        }
        return -value;
    }

    @SafeVarargs
    public static String randomString(int length, RandomizerBumper<String> ... randomizerBumpers) {
        block0: for (int i = 0; i < 100; ++i) {
            String randomString = PwdGenerator.getPassword((int)length);
            for (RandomizerBumper<String> randomizerBumper : randomizerBumpers) {
                if (!randomizerBumper.accept(randomString)) continue block0;
            }
            return randomString;
        }
        throw new IllegalStateException("Unable to generate a random string that is acceptable by all randomizer bumpers " + Arrays.toString(randomizerBumpers) + " after " + 100 + " tries");
    }

    @SafeVarargs
    public static String randomString(RandomizerBumper<String> ... randomizerBumpers) {
        return RandomTestUtil.randomString(8, randomizerBumpers);
    }

    @SafeVarargs
    public static String[] randomStrings(int count, RandomizerBumper<String> ... randomizerBumpers) {
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            strings[i] = RandomTestUtil.randomString(randomizerBumpers);
        }
        return strings;
    }

    public static UnicodeProperties randomUnicodeProperties(int propertyCount, int keyLength, int valueLength) {
        UnicodeProperties unicodeProperties = new UnicodeProperties();
        for (int i = 0; i < propertyCount; ++i) {
            unicodeProperties.put(RandomTestUtil.randomString(keyLength, new RandomizerBumper[0]), RandomTestUtil.randomString(valueLength, new RandomizerBumper[0]));
        }
        return unicodeProperties;
    }
}

