/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule.callback;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.SynchronousDestination;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.test.rule.Sync;
import com.liferay.portal.kernel.test.rule.SynchronousDestinationTestRule;
import com.liferay.portal.kernel.test.rule.callback.TestCallback;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.junit.Test;
import org.junit.runner.Description;

public class SynchronousDestinationTestCallback
implements TestCallback<SyncHandler, SyncHandler> {
    public static final SynchronousDestinationTestCallback INSTANCE = new SynchronousDestinationTestCallback();
    private static final TransactionConfig _transactionConfig;

    @Override
    public void afterClass(Description description, SyncHandler syncHandler) throws Exception {
        if (syncHandler != null) {
            syncHandler.restorePreviousSync();
        }
    }

    @Override
    public void afterMethod(Description description, SyncHandler syncHandler, Object target) {
        if (syncHandler != null) {
            syncHandler.restorePreviousSync();
        }
    }

    @Override
    public SyncHandler beforeClass(Description description) throws Throwable {
        Class<?> testClass = description.getTestClass();
        Sync sync = testClass.getAnnotation(Sync.class);
        if (sync != null) {
            return this._createSyncHandler(sync);
        }
        boolean hasSyncedMethod = false;
        for (Method method : testClass.getMethods()) {
            if (method.getAnnotation(Sync.class) == null || method.getAnnotation(Test.class) == null) continue;
            hasSyncedMethod = true;
            break;
        }
        if (!hasSyncedMethod) {
            throw new AssertionError((Object)(testClass.getName() + " uses " + SynchronousDestinationTestRule.class.getName() + " without any usage of " + Sync.class.getName()));
        }
        return null;
    }

    @Override
    public SyncHandler beforeMethod(Description description, Object target) {
        Class<?> testClass = description.getTestClass();
        Sync sync = testClass.getAnnotation(Sync.class);
        if (sync != null) {
            return null;
        }
        sync = description.getAnnotation(Sync.class);
        if (sync == null) {
            return null;
        }
        return this._createSyncHandler(sync);
    }

    protected SynchronousDestinationTestCallback() {
    }

    private SyncHandler _createSyncHandler(Sync sync) {
        SyncHandler syncHandler = new SyncHandler();
        syncHandler.setForceSync(ProxyModeThreadLocal.isForceSync());
        syncHandler.setSync(sync);
        syncHandler.enableSync();
        return syncHandler;
    }

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.NOT_SUPPORTED);
        builder.setRollbackForClasses(new Class[]{PortalException.class, SystemException.class});
        _transactionConfig = builder.build();
    }

    private static class CleanTransactionSynchronousDestination
    extends SynchronousDestination {
        private CleanTransactionSynchronousDestination() {
        }

        public void send(final Message message) {
            try {
                TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        CleanTransactionSynchronousDestination.super.send(message);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static class SyncHandler {
        private final List<String> _absentDestinationNames = new ArrayList<String>();
        private final List<Destination> _asyncServiceDestinations = new ArrayList<Destination>();
        private boolean _forceSync;
        private Sync _sync;

        public BaseDestination createSynchronousDestination(String destinationName) {
            SynchronousDestination synchronousDestination = null;
            synchronousDestination = this._sync != null && this._sync.cleanTransaction() ? new CleanTransactionSynchronousDestination() : new SynchronousDestination();
            synchronousDestination.setName(destinationName);
            return synchronousDestination;
        }

        public void enableSync() {
            if (this._sync == null) {
                return;
            }
            ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
            Filter asyncFilter = this._registerDestinationFilter("liferay/async_service");
            Filter backgroundTaskFilter = this._registerDestinationFilter("liferay/background_task");
            Filter backgroundTaskStatusFilter = this._registerDestinationFilter("liferay/background_task_status");
            Filter mailFilter = this._registerDestinationFilter("liferay/mail");
            Filter pdfProcessorFilter = this._registerDestinationFilter("liferay/document_library_pdf_processor");
            Filter rawMetaDataProcessorFilter = this._registerDestinationFilter("liferay/document_library_raw_metadata_processor");
            Filter subscrpitionSenderFilter = this._registerDestinationFilter("liferay/subscription_sender");
            serviceDependencyManager.registerDependencies(new Filter[]{asyncFilter, backgroundTaskFilter, backgroundTaskStatusFilter, mailFilter, pdfProcessorFilter, rawMetaDataProcessorFilter, subscrpitionSenderFilter});
            serviceDependencyManager.waitForDependencies();
            ProxyModeThreadLocal.setForceSync((boolean)true);
            this.replaceDestination("liferay/async_service");
            this.replaceDestination("liferay/background_task");
            this.replaceDestination("liferay/background_task_status");
            this.replaceDestination("liferay/document_library_pdf_processor");
            this.replaceDestination("liferay/document_library_raw_metadata_processor");
            this.replaceDestination("liferay/document_library_sync_event_processor");
            this.replaceDestination("liferay/mail");
            this.replaceDestination("liferay/scheduler_engine");
            this.replaceDestination("liferay/subscription_sender");
            for (String searchEngineId : SearchEngineHelperUtil.getSearchEngineIds()) {
                this.replaceDestination(SearchEngineHelperUtil.getSearchReaderDestinationName((String)searchEngineId));
                this.replaceDestination(SearchEngineHelperUtil.getSearchWriterDestinationName((String)searchEngineId));
            }
        }

        public void replaceDestination(String destinationName) {
            MessageBus messageBus = MessageBusUtil.getMessageBus();
            Destination destination = messageBus.getDestination(destinationName);
            if (destination instanceof BaseAsyncDestination) {
                this._asyncServiceDestinations.add(destination);
                messageBus.replace((Destination)this.createSynchronousDestination(destinationName), false);
            }
            if (destination == null) {
                this._absentDestinationNames.add(destinationName);
                messageBus.addDestination((Destination)this.createSynchronousDestination(destinationName));
            }
        }

        public void restorePreviousSync() {
            if (this._sync == null) {
                return;
            }
            ProxyModeThreadLocal.setForceSync((boolean)this._forceSync);
            MessageBus messageBus = MessageBusUtil.getMessageBus();
            for (Destination destination : this._asyncServiceDestinations) {
                messageBus.replace(destination);
            }
            this._asyncServiceDestinations.clear();
            for (String absentDestinationName : this._absentDestinationNames) {
                messageBus.removeDestination(absentDestinationName);
            }
        }

        public void setForceSync(boolean forceSync) {
            this._forceSync = forceSync;
        }

        public void setSync(Sync sync) {
            this._sync = sync;
        }

        private Filter _registerDestinationFilter(String destinationName) {
            Registry registry = RegistryUtil.getRegistry();
            return registry.getFilter("(&(destination.name=" + destinationName + ")(objectClass=" + Destination.class.getName() + "))");
        }
    }
}

