/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule.callback;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.rule.callback.BaseTestCallback;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.runner.Description;

public class DeleteAfterTestRunTestCallback
extends BaseTestCallback<Object, Object> {
    public static final DeleteAfterTestRunTestCallback INSTANCE = new DeleteAfterTestRunTestCallback();
    private static final Log _log = LogFactoryUtil.getLog(DeleteAfterTestRunTestCallback.class);
    private static final Set<Class<?>> _orderedClasses = new LinkedHashSet<Class>(Arrays.asList(User.class, Organization.class, Role.class, UserGroup.class, Group.class, LayoutPrototype.class, LayoutSetPrototype.class, Company.class));

    @Override
    public void afterMethod(Description description, Object object, Object target) {
        HashMap deleteAfterTestRunFieldBags = new HashMap();
        for (Class<?> testClass = description.getTestClass(); testClass != null; testClass = testClass.getSuperclass()) {
            for (Field field : testClass.getDeclaredFields()) {
                DeleteAfterTestRun deleteAfterTestRun = field.getAnnotation(DeleteAfterTestRun.class);
                if (deleteAfterTestRun == null) continue;
                Class<?> fieldClass = field.getType();
                if (PersistedModel.class.isAssignableFrom(fieldClass)) {
                    this.addField(deleteAfterTestRunFieldBags, fieldClass, field);
                    continue;
                }
                if (fieldClass.isArray()) {
                    if (!PersistedModel.class.isAssignableFrom(fieldClass.getComponentType())) {
                        throw new IllegalArgumentException("Unable to annotate field " + field + " because it is not an array of type " + PersistedModel.class.getName());
                    }
                    this.addField(deleteAfterTestRunFieldBags, fieldClass.getComponentType(), field);
                    continue;
                }
                if (Collection.class.isAssignableFrom(fieldClass)) {
                    try {
                        field.setAccessible(true);
                        Collection collection = (Collection)field.get(target);
                        if (collection == null || collection.isEmpty()) continue;
                        Class<? extends PersistedModel> collectionType = this.getCollectionType(collection);
                        if (collectionType == null) {
                            throw new IllegalArgumentException("Unable to annotate field " + field + " because it is not a collection of type " + PersistedModel.class.getName());
                        }
                        this.addField(deleteAfterTestRunFieldBags, collectionType, field);
                    }
                    catch (Exception e) {
                        _log.error((Object)"Unable to detect collection element type", (Throwable)e);
                    }
                    continue;
                }
                StringBundler sb = new StringBundler(6);
                sb.append("Unable to annotate field ");
                sb.append((Object)field);
                sb.append(" because it is not type of ");
                sb.append(PersistedModel.class.getName());
                sb.append(" nor an array or collection of ");
                sb.append(PersistedModel.class.getName());
                throw new IllegalArgumentException(sb.toString());
            }
        }
        Set set = deleteAfterTestRunFieldBags.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Class<?> clazz = (Class<?>)entry.getKey();
            if (_orderedClasses.contains(clazz)) continue;
            iterator.remove();
            this.removeField((FieldBag)entry.getValue(), target);
        }
        for (Class<?> clazz : _orderedClasses) {
            FieldBag fieldBag = (FieldBag)deleteAfterTestRunFieldBags.remove(clazz);
            if (fieldBag == null) continue;
            this.removeField(fieldBag, target);
        }
    }

    protected void addField(Map<Class<?>, FieldBag> deleteAfterTestRunFieldBags, Class<?> clazz, Field field) {
        FieldBag fieldBag = deleteAfterTestRunFieldBags.get(clazz);
        if (fieldBag == null) {
            fieldBag = new FieldBag(clazz);
            deleteAfterTestRunFieldBags.put(clazz, fieldBag);
        }
        field.setAccessible(true);
        fieldBag.addField(field);
    }

    protected Class<? extends PersistedModel> getCollectionType(Collection<?> collection) {
        Class collectionType = null;
        block0: for (Object object : collection) {
            LinkedList classes = new LinkedList();
            classes.add(object.getClass());
            Class clazz = null;
            while ((clazz = (Class)classes.poll()) != null) {
                if (ArrayUtil.contains((Object[])clazz.getInterfaces(), PersistedModel.class)) {
                    if (collectionType == null) {
                        collectionType = clazz;
                        continue block0;
                    }
                    if (collectionType == clazz) continue block0;
                    return null;
                }
                classes.add(clazz.getSuperclass());
                classes.addAll(Arrays.asList(clazz.getInterfaces()));
            }
        }
        return collectionType;
    }

    protected void removeField(FieldBag fieldBag, Object instance) {
        try {
            Class<?> fieldClass = fieldBag.getFieldClass();
            PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)fieldClass.getName());
            for (Field field : fieldBag.getFields()) {
                Object object = field.get(instance);
                if (object == null) continue;
                Class<?> objectClass = object.getClass();
                if (objectClass.isArray()) {
                    for (PersistedModel persistedModel : (PersistedModel[])object) {
                        if (persistedModel == null) continue;
                        persistedModelLocalService.deletePersistedModel(persistedModel);
                    }
                } else if (Collection.class.isAssignableFrom(objectClass)) {
                    Collection collection = (Collection)object;
                    for (PersistedModel persistedModel : collection) {
                        persistedModelLocalService.deletePersistedModel(persistedModel);
                    }
                } else {
                    persistedModelLocalService.deletePersistedModel((PersistedModel)object);
                }
                field.set(instance, null);
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to delete", (Throwable)e);
        }
    }

    private DeleteAfterTestRunTestCallback() {
    }

    protected static class FieldBag {
        private final Class<?> _fieldClass;
        private final List<Field> _fields = new ArrayList<Field>();

        public FieldBag(Class<?> fieldClass) {
            this._fieldClass = fieldClass;
        }

        public void addField(Field field) {
            this._fields.add(field);
        }

        public Class<?> getFieldClass() {
            return this._fieldClass;
        }

        public List<Field> getFields() {
            return this._fields;
        }
    }
}

