/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.rule.BaseTestRule;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class TransactionalTestRule
implements TestRule {
    public static final TransactionalTestRule INSTANCE = new TransactionalTestRule();
    private final TransactionConfig _transactionConfig;

    public TransactionalTestRule() {
        this(Propagation.SUPPORTS);
    }

    public TransactionalTestRule(Propagation propagation) {
        this._transactionConfig = TransactionConfig.Factory.create((Propagation)propagation, (Class[])new Class[]{PortalException.class, SystemException.class}, (Class[])new Class[0]);
    }

    @Override
    public Statement apply(Statement statement, final Description description) {
        Statement currentStatement = statement;
        while (true) {
            if (currentStatement instanceof BaseTestRule.StatementWrapper) {
                BaseTestRule.StatementWrapper statementWrapper = (BaseTestRule.StatementWrapper)currentStatement;
                currentStatement = statementWrapper.getStatement();
                continue;
            }
            if (currentStatement instanceof RunRules) {
                currentStatement = (Statement)ReflectionTestUtil.getFieldValue(currentStatement, "statement");
                continue;
            }
            if (currentStatement instanceof RunBefores) {
                this.replaceFrameworkMethods(currentStatement, "befores");
                currentStatement = (Statement)ReflectionTestUtil.getFieldValue(currentStatement, "next");
                continue;
            }
            if (!(currentStatement instanceof RunAfters)) break;
            this.replaceFrameworkMethods(currentStatement, "afters");
            currentStatement = (Statement)ReflectionTestUtil.getFieldValue(currentStatement, "next");
        }
        return new BaseTestRule.StatementWrapper(statement){

            @Override
            public void evaluate() throws Throwable {
                TransactionInvokerUtil.invoke((TransactionConfig)TransactionalTestRule.this.getTransactionConfig(description.getAnnotation(Transactional.class)), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            statement.evaluate();
                        }
                        catch (Throwable t) {
                            ReflectionUtil.throwException((Throwable)t);
                        }
                        return null;
                    }
                });
            }
        };
    }

    public TransactionConfig getTransactionConfig(Transactional transactional) {
        if (transactional != null) {
            return TransactionConfig.Factory.create((Isolation)transactional.isolation(), (Propagation)transactional.propagation(), (boolean)transactional.readOnly(), (int)transactional.timeout(), (Class[])transactional.rollbackFor(), (String[])transactional.rollbackForClassName(), (Class[])transactional.noRollbackFor(), (String[])transactional.noRollbackForClassName());
        }
        return this._transactionConfig;
    }

    protected void replaceFrameworkMethods(Statement statement, String name) {
        ArrayList<FrameworkMethod> newFrameworkMethods = new ArrayList<FrameworkMethod>();
        List frameworkMethods = (List)ReflectionTestUtil.getFieldValue(statement, name);
        for (FrameworkMethod frameworkMethod : frameworkMethods) {
            if (frameworkMethod instanceof TransactionalFrameworkMethod) {
                newFrameworkMethods.add(frameworkMethod);
                continue;
            }
            Transactional transactional = frameworkMethod.getAnnotation(Transactional.class);
            if (transactional == null) {
                newFrameworkMethods.add(new TransactionalFrameworkMethod(frameworkMethod.getMethod(), this._transactionConfig));
                continue;
            }
            newFrameworkMethods.add(new TransactionalFrameworkMethod(frameworkMethod.getMethod(), this.getTransactionConfig(transactional)));
        }
        ReflectionTestUtil.setFieldValue(statement, name, newFrameworkMethods);
    }

    protected static class TransactionalFrameworkMethod
    extends FrameworkMethod {
        private final TransactionConfig _transactionConfig;

        @Override
        public Object invokeExplosively(final Object target, final Object ... params) throws Throwable {
            return TransactionInvokerUtil.invoke((TransactionConfig)this._transactionConfig, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        return TransactionalFrameworkMethod.super.invokeExplosively(target, params);
                    }
                    catch (Throwable t) {
                        ReflectionUtil.throwException((Throwable)t);
                        return null;
                    }
                }
            });
        }

        protected TransactionalFrameworkMethod(Method method, TransactionConfig transactionConfig) {
            super(method);
            this._transactionConfig = transactionConfig;
        }
    }
}

