/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessUtil;
import com.liferay.portal.kernel.test.GCUtil;
import com.liferay.portal.kernel.util.HeapUtil;
import java.util.Date;
import java.util.concurrent.Future;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class HeapDumpTestRule
implements TestRule {
    public static final HeapDumpTestRule INSTANCE = new HeapDumpTestRule(true);
    private final boolean _live;

    public HeapDumpTestRule(boolean live) {
        this._live = live;
    }

    @Override
    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void evaluate() throws Throwable {
                Date date = new Date();
                GCUtil.fullGC(HeapDumpTestRule.this._live);
                Future future = HeapUtil.heapDump((boolean)HeapDumpTestRule.this._live, (boolean)true, (String)(description.toString() + "-" + date + "-before.bin"), (OutputProcessor)ProcessUtil.ECHO_OUTPUT_PROCESSOR);
                future.get();
                try {
                    statement.evaluate();
                }
                finally {
                    GCUtil.fullGC(HeapDumpTestRule.this._live);
                    future = HeapUtil.heapDump((boolean)HeapDumpTestRule.this._live, (boolean)true, (String)(description.toString() + "-" + date + "-after.bin"), (OutputProcessor)ProcessUtil.ECHO_OUTPUT_PROCESSOR);
                    future.get();
                }
            }
        };
    }
}

