/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CodeCoverageAssertor
implements TestRule {
    public static final CodeCoverageAssertor INSTANCE = new CodeCoverageAssertor();
    private static final Method _ASSERT_COVERAGE_METHOD;
    private static final Method _DYNAMICALLY_INSTRUMENT_METHOD;
    private final String[] _excludes;
    private final boolean _includeInnerClasses;
    private final String[] _includes;

    public CodeCoverageAssertor() {
        this(null, null, true);
    }

    public CodeCoverageAssertor(String[] includes, String[] excludes, boolean includeInnerClasses) {
        this._includes = includes;
        this._excludes = excludes;
        this._includeInnerClasses = includeInnerClasses;
    }

    public void appendAssertClasses(List<Class<?>> assertClasses) {
    }

    @Override
    public Statement apply(final Statement statement, final Description description) {
        if (description.getMethodName() != null) {
            return statement;
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void evaluate() throws Throwable {
                String className = CodeCoverageAssertor.this.beforeClass(description);
                String whipStaticInstrument = System.getProperty("whip.static.instrument");
                System.setProperty("whip.static.instrument", "true");
                try {
                    statement.evaluate();
                }
                finally {
                    CodeCoverageAssertor.this.afterClass(description, className);
                    if (whipStaticInstrument == null) {
                        System.clearProperty("whip.static.instrument");
                    } else {
                        System.setProperty("whip.static.instrument", whipStaticInstrument);
                    }
                }
            }
        };
    }

    protected void afterClass(Description description, String className) throws Throwable {
        ArrayList assertClasses = new ArrayList();
        if (className != null) {
            ClassLoader classLoader = this.getClassLoader();
            Class<?> clazz = classLoader.loadClass(className);
            assertClasses.add(clazz);
        }
        this.appendAssertClasses(assertClasses);
        try {
            _ASSERT_COVERAGE_METHOD.invoke(null, this._includeInnerClasses, assertClasses.toArray(new Class[assertClasses.size()]));
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    protected String beforeClass(Description description) throws Throwable {
        String className = description.getClassName();
        if (className.endsWith("Test")) {
            className = className.substring(0, className.length() - 4);
        }
        String jvmClassPath = ClassPathUtil.getJVMClassPath((boolean)false);
        URL[] urls = ClassPathUtil.getClassPathURLs((String)jvmClassPath);
        URLClassLoader classLoader = new URLClassLoader(urls, null);
        try {
            classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            className = null;
        }
        String[] includes = this._includes;
        if (includes == null) {
            includes = this._generateIncludes(classLoader, className);
        }
        try {
            _DYNAMICALLY_INSTRUMENT_METHOD.invoke(null, includes, this._excludes);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        return className;
    }

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }

    private String[] _generateIncludes(ClassLoader classLoader, String mainClassName) throws Exception {
        ArrayList assertClasses = new ArrayList();
        if (mainClassName != null) {
            Class<?> mainClass = classLoader.loadClass(mainClassName);
            assertClasses.add(mainClass);
            if (this._includeInnerClasses) {
                assertClasses.addAll(Arrays.asList(mainClass.getDeclaredClasses()));
            }
        }
        if (this.getClass() != CodeCoverageAssertor.class) {
            Class<?> clazz = this.getClass();
            Class<?> reloadedClass = classLoader.loadClass(clazz.getName());
            Method appendAssertClassesMethod = reloadedClass.getMethod("appendAssertClasses", List.class);
            appendAssertClassesMethod.setAccessible(true);
            Constructor<?> constructor = reloadedClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object reloadedObject = constructor.newInstance(new Object[0]);
            appendAssertClassesMethod.invoke(reloadedObject, assertClasses);
        }
        String[] includes = new String[assertClasses.size()];
        for (int i = 0; i < assertClasses.size(); ++i) {
            Class assertClass = (Class)assertClasses.get(i);
            includes[i] = StringUtil.replace((String)assertClass.getName(), (char[])new char[]{'.', '$'}, (String[])new String[]{"/", "\\$"});
        }
        return includes;
    }

    static {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> instrumentationAgentClass = systemClassLoader.loadClass("com.liferay.whip.agent.InstrumentationAgent");
            _ASSERT_COVERAGE_METHOD = instrumentationAgentClass.getMethod("assertCoverage", Boolean.TYPE, Class[].class);
            _DYNAMICALLY_INSTRUMENT_METHOD = instrumentationAgentClass.getMethod("dynamicallyInstrument", String[].class, String[].class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

