/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.rule.ArquillianClassRuleHandler;
import com.liferay.portal.kernel.test.rule.ArquillianUtil;
import com.liferay.portal.kernel.test.rule.callback.TestCallback;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BaseTestRule<C, M>
implements ArquillianClassRuleHandler,
TestRule {
    private static final Map<Class<?>, Deque<Object>> _classCarryOnMap = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private final ThreadLocal<Boolean> _handleAfterClassThreadLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ThreadLocal<Boolean> _handleBeforeClassThreadLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final TestCallback<C, M> _testCallback;

    public BaseTestRule(TestCallback<C, M> testCallback) {
        this._testCallback = testCallback;
    }

    @Override
    public final Statement apply(Statement statement, final Description description) {
        String methodName = description.getMethodName();
        if (methodName != null) {
            return new StatementWrapper(statement){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void evaluate() throws Throwable {
                    Object target = BaseTestRule.this.inspectTarget(this.statement);
                    Object m = BaseTestRule.this._testCallback.beforeMethod(description, target);
                    try {
                        this.statement.evaluate();
                    }
                    finally {
                        BaseTestRule.this._testCallback.afterMethod(description, m, target);
                    }
                }
            };
        }
        boolean arquillianTest = ArquillianUtil.isArquillianTest(description);
        if (!arquillianTest) {
            return new StatementWrapper(statement){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void evaluate() throws Throwable {
                    Object c = BaseTestRule.this._testCallback.beforeClass(description);
                    try {
                        this.statement.evaluate();
                    }
                    finally {
                        BaseTestRule.this._testCallback.afterClass(description, c);
                    }
                }
            };
        }
        return new StatementWrapper(statement){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void evaluate() throws Throwable {
                Deque deque;
                Class<?> clazz = description.getTestClass();
                if (((Boolean)BaseTestRule.this._handleBeforeClassThreadLocal.get()).booleanValue()) {
                    deque = (LinkedList)_classCarryOnMap.get(clazz);
                    if (deque == null) {
                        deque = new LinkedList();
                        _classCarryOnMap.put(clazz, deque);
                    }
                    deque.addLast(BaseTestRule.this._testCallback.beforeClass(description));
                }
                try {
                    this.statement.evaluate();
                }
                finally {
                    if (((Boolean)BaseTestRule.this._handleAfterClassThreadLocal.get()).booleanValue()) {
                        deque = (Deque)_classCarryOnMap.get(clazz);
                        BaseTestRule.this._testCallback.afterClass(description, deque.removeLast());
                        if (deque.isEmpty()) {
                            _classCarryOnMap.remove(clazz);
                        }
                    }
                }
            }
        };
    }

    @Override
    public void handleAfterClass(boolean enable) {
        this._handleAfterClassThreadLocal.set(enable);
    }

    @Override
    public void handleBeforeClass(boolean enable) {
        this._handleBeforeClassThreadLocal.set(enable);
    }

    protected Object inspectTarget(Statement statement) {
        while (statement instanceof StatementWrapper) {
            StatementWrapper statementWrapper = (StatementWrapper)statement;
            statement = statementWrapper.getStatement();
        }
        if (statement instanceof InvokeMethod || statement instanceof RunAfters || statement instanceof RunBefores) {
            return ReflectionTestUtil.getFieldValue(statement, "target");
        }
        if (statement instanceof ExpectException) {
            return this.inspectTarget((Statement)ReflectionTestUtil.getFieldValue(statement, "next"));
        }
        if (statement instanceof FailOnTimeout) {
            return this.inspectTarget((Statement)ReflectionTestUtil.getFieldValue(statement, "originalStatement"));
        }
        throw new IllegalStateException("Unknow statement " + statement);
    }

    public static abstract class StatementWrapper
    extends Statement {
        protected final Statement statement;

        public StatementWrapper(Statement statement) {
            this.statement = statement;
        }

        public Statement getStatement() {
            return this.statement;
        }
    }
}

