/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.junit;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import java.io.Serializable;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class BridgeJUnitTestRunner
extends BlockJUnit4ClassRunner {
    private static final Map<Class<?>, RunNotifier> _runNotifiers = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);

    public static RunNotifier getRunNotifier(Class<?> clazz) {
        return _runNotifiers.get(clazz);
    }

    public static Result runBridgeTests(BridgeRunListener bridgeRunListener, Class<?> ... testClasses) {
        JUnitCore junitCore = new JUnitCore();
        junitCore.addListener(bridgeRunListener);
        return junitCore.run(testClasses);
    }

    public BridgeJUnitTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    @Override
    public void run(RunNotifier runNotifier) {
        TestClass testClass = this.getTestClass();
        _runNotifiers.put(testClass.getJavaClass(), runNotifier);
        super.run(runNotifier);
    }

    public static class BridgeRunListener
    extends RunListener
    implements Serializable {
        protected final Class<?> testClass;
        private static final long serialVersionUID = 1L;

        public BridgeRunListener(Class<?> testClass) {
            this.testClass = testClass;
        }

        @Override
        public void testAssumptionFailure(Failure failure) {
            this.bridge("fireTestAssumptionFailed", failure);
        }

        @Override
        public void testFailure(Failure failure) {
            this.bridge("fireTestFailure", failure);
        }

        @Override
        public void testFinished(Description description) {
            this.bridge("fireTestFinished", description);
        }

        @Override
        public void testIgnored(Description description) {
            this.bridge("fireTestIgnored", description);
        }

        @Override
        public void testRunFinished(Result result) {
            this.bridge("fireTestRunFinished", result);
        }

        @Override
        public void testRunStarted(Description description) {
            this.bridge("fireTestRunStarted", description);
        }

        @Override
        public void testStarted(Description description) {
            this.bridge("fireTestStarted", description);
        }

        protected void bridge(String methodName, Object argument) {
            ReflectionTestUtil.invoke(BridgeJUnitTestRunner.getRunNotifier(this.testClass), methodName, new Class[]{argument.getClass()}, argument);
        }
    }
}

