/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ReflectionTestUtil {
    public static <T> T getAndSetFieldValue(Class<?> clazz, String fieldName, T newValue) {
        Field field = ReflectionTestUtil.getField(clazz, fieldName);
        try {
            Object t = field.get(null);
            field.set(null, newValue);
            return (T)t;
        }
        catch (Exception e) {
            return (T)ReflectionUtil.throwException((Throwable)e);
        }
    }

    public static <T> T getAndSetFieldValue(Object instance, String fieldName, T newValue) {
        Field field = ReflectionTestUtil.getField(instance.getClass(), fieldName);
        try {
            Object t = field.get(instance);
            field.set(instance, newValue);
            return (T)t;
        }
        catch (Exception e) {
            return (T)ReflectionUtil.throwException((Throwable)e);
        }
    }

    public static Method getBridgeMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method method = ReflectionTestUtil.getMethod(clazz, methodName, parameterTypes);
        if (method.isBridge()) {
            return method;
        }
        Method bridgeMethod = ReflectionTestUtil._findBridgeMethod(clazz.getMethods(), method);
        if (bridgeMethod != null) {
            return bridgeMethod;
        }
        while (clazz != null) {
            bridgeMethod = ReflectionTestUtil._findBridgeMethod(clazz.getDeclaredMethods(), method);
            if (bridgeMethod != null) {
                return bridgeMethod;
            }
            clazz = clazz.getSuperclass();
        }
        return (Method)ReflectionUtil.throwException((Throwable)new NoSuchMethodException("No bridge method on " + clazz + " with name " + methodName + " and parameter types " + Arrays.toString(parameterTypes)));
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            ReflectionUtil.unfinalField((Field)field);
            return field;
        }
        catch (NoSuchFieldException nsfe) {
        }
        catch (Exception e) {
            return (Field)ReflectionUtil.throwException((Throwable)e);
        }
        while (clazz != null) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                ReflectionUtil.unfinalField((Field)field);
                return field;
            }
            catch (NoSuchFieldException nsfe) {
                clazz = clazz.getSuperclass();
            }
            catch (Exception e) {
                return (Field)ReflectionUtil.throwException((Throwable)e);
            }
        }
        return (Field)ReflectionUtil.throwException((Throwable)new NoSuchFieldException("No field on " + clazz + " with name " + fieldName));
    }

    public static <T> T getFieldValue(Class<?> clazz, String fieldName) {
        Field field = ReflectionTestUtil.getField(clazz, fieldName);
        try {
            return (T)field.get(null);
        }
        catch (Exception e) {
            return (T)ReflectionUtil.throwException((Throwable)e);
        }
    }

    public static <T> T getFieldValue(Object instance, String fieldName) {
        Field field = ReflectionTestUtil.getField(instance.getClass(), fieldName);
        try {
            return (T)field.get(instance);
        }
        catch (Exception e) {
            return (T)ReflectionUtil.throwException((Throwable)e);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException nsme) {
            while (clazz != null) {
                try {
                    Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException nsme2) {
                    clazz = clazz.getSuperclass();
                }
            }
            return (Method)ReflectionUtil.throwException((Throwable)new NoSuchMethodException("No method on " + clazz + " with name " + methodName + " and parameter types " + Arrays.toString(parameterTypes)));
        }
    }

    public static <T> T invoke(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object ... parameters) {
        Method method = ReflectionTestUtil.getMethod(clazz, methodName, parameterTypes);
        try {
            return (T)method.invoke(null, parameters);
        }
        catch (InvocationTargetException ite) {
            return (T)ReflectionUtil.throwException((Throwable)ite.getCause());
        }
        catch (Exception e) {
            return (T)ReflectionUtil.throwException((Throwable)e);
        }
    }

    public static <T> T invoke(Object instance, String methodName, Class<?>[] parameterTypes, Object ... parameters) {
        Method method = ReflectionTestUtil.getMethod(instance.getClass(), methodName, parameterTypes);
        try {
            return (T)method.invoke(instance, parameters);
        }
        catch (InvocationTargetException ite) {
            return (T)ReflectionUtil.throwException((Throwable)ite.getCause());
        }
        catch (Exception e) {
            return (T)ReflectionUtil.throwException((Throwable)e);
        }
    }

    public static <T> T invokeBridge(Object instance, String methodName, Class<?>[] parameterTypes, Object ... parameters) {
        Method method = ReflectionTestUtil.getBridgeMethod(instance.getClass(), methodName, parameterTypes);
        try {
            return (T)method.invoke(instance, parameters);
        }
        catch (InvocationTargetException ite) {
            return (T)ReflectionUtil.throwException((Throwable)ite.getCause());
        }
        catch (Exception e) {
            return (T)ReflectionUtil.throwException((Throwable)e);
        }
    }

    public static <T extends Enum<T>> T newEnumElement(Class<T> enumClass, Class<?>[] constructorParameterTypes, String name, int ordinal, Object ... constructorParameters) {
        Class[] parameterTypes = null;
        if (constructorParameterTypes != null && constructorParameterTypes.length != 0) {
            parameterTypes = new Class[constructorParameterTypes.length + 2];
            parameterTypes[0] = String.class;
            parameterTypes[1] = Integer.TYPE;
            System.arraycopy(constructorParameterTypes, 0, parameterTypes, 2, constructorParameterTypes.length);
        } else {
            parameterTypes = new Class[]{String.class, Integer.TYPE};
        }
        try {
            Constructor<T> constructor = enumClass.getDeclaredConstructor(parameterTypes);
            Method acquireConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, (String)"acquireConstructorAccessor", (Class[])new Class[0]);
            acquireConstructorAccessorMethod.invoke(constructor, new Object[0]);
            Field constructorAccessorField = ReflectionUtil.getDeclaredField(Constructor.class, (String)"constructorAccessor");
            Object constructorAccessor = constructorAccessorField.get(constructor);
            Method newInstanceMethod = ReflectionUtil.getDeclaredMethod(constructorAccessor.getClass(), (String)"newInstance", (Class[])new Class[]{Object[].class});
            Object[] parameters = null;
            if (constructorParameters != null && constructorParameters.length != 0) {
                parameters = new Object[constructorParameters.length + 2];
                parameters[0] = name;
                parameters[1] = ordinal;
                System.arraycopy(constructorParameters, 0, parameters, 2, constructorParameters.length);
            } else {
                parameters = new Object[]{name, ordinal};
            }
            return (T)((Enum)newInstanceMethod.invoke(constructorAccessor, new Object[]{parameters}));
        }
        catch (Exception e) {
            return (T)((Enum)ReflectionUtil.throwException((Throwable)e));
        }
    }

    public static <T extends Enum<T>> T newEnumElement(Class<T> enumClass, String name, int ordinal) {
        return ReflectionTestUtil.newEnumElement(enumClass, null, name, ordinal, null);
    }

    public static void setFieldValue(Class<?> clazz, String fieldName, Object value) {
        Field field = ReflectionTestUtil.getField(clazz, fieldName);
        try {
            field.set(null, value);
        }
        catch (Exception e) {
            ReflectionUtil.throwException((Throwable)e);
        }
    }

    public static void setFieldValue(Object instance, String fieldName, Object value) {
        Field field = ReflectionTestUtil.getField(instance.getClass(), fieldName);
        try {
            field.set(instance, value);
        }
        catch (Exception e) {
            ReflectionUtil.throwException((Throwable)e);
        }
    }

    private static Method _findBridgeMethod(Method[] methods, Method method) {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        block0: for (Method currentMethod : methods) {
            Class<?>[] currentParameterTypes;
            if (!currentMethod.isBridge() || !name.equals(currentMethod.getName()) || (currentParameterTypes = currentMethod.getParameterTypes()).length != parameterTypes.length) continue;
            for (int i = 0; i < currentParameterTypes.length; ++i) {
                if (!currentParameterTypes[i].isAssignableFrom(parameterTypes[i])) continue block0;
            }
            currentMethod.setAccessible(true);
            return currentMethod;
        }
        return null;
    }
}

