/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import org.junit.Assume;

public class FixedIssuesUtils {
    private static final FixedIssuesUtils _instance = new FixedIssuesUtils();
    private final String[] _fixedIssues = StringUtil.split((String)GetterUtil.getString((String)System.getProperty("fixed.issues")));

    public static void assumeIssueIsFixed(String issue) {
        Assume.assumeTrue(FixedIssuesUtils.isIssueFixed(issue));
    }

    public static void assumeIssueIsNotFixed(String issue) {
        Assume.assumeFalse(FixedIssuesUtils.isIssueFixed(issue));
    }

    public static boolean isIssueFixed(String issue) {
        return ArrayUtil.contains((Object[])FixedIssuesUtils._instance._fixedIssues, (Object)issue);
    }

    private FixedIssuesUtils() {
    }
}

