/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class AssertUtils {
    public static void assertEquals(Blob expectedBlob, Blob actualBlob) throws Exception {
        try (InputStream expectInputStream = expectedBlob.getBinaryStream();
             InputStream actualInputStream = actualBlob.getBinaryStream();){
            int expectValue;
            do {
                expectValue = expectInputStream.read();
                int actualValue = actualInputStream.read();
                AssertUtils.assertEquals(expectValue, actualValue);
            } while (expectValue != -1);
        }
    }

    public static void assertEquals(double expectedDouble, double actualDouble) {
        Assert.assertEquals(expectedDouble, actualDouble, 0.0);
    }

    public static void assertEquals(double[] expectedArray, double[] actualArray) {
        Assert.assertArrayEquals(expectedArray, actualArray, 0.0);
    }

    public static void assertEquals(List<?> expectedList, List<?> actualList) {
        Assert.assertEquals("The lists have different sizes", expectedList.size(), actualList.size());
        Assert.assertTrue(expectedList.containsAll(actualList));
    }

    public static void assertEquals(Map<String, ?> expectedMap, Map<String, ?> actualMap) {
        Assert.assertEquals("The maps have different sizes", expectedMap.size(), actualMap.size());
        for (String name : expectedMap.keySet()) {
            Assert.assertEquals("The values for key '" + name + "' are different", MapUtil.getString(expectedMap, (String)name), MapUtil.getString(actualMap, (String)name));
        }
    }

    public static void assertEqualsIgnoreCase(String expectedString, String actualString) {
        if (expectedString != null) {
            expectedString = StringUtil.toLowerCase((String)expectedString);
        }
        if (actualString != null) {
            actualString = StringUtil.toLowerCase((String)actualString);
        }
        Assert.assertEquals(expectedString, actualString);
    }

    public static void assertEqualsSorted(String[] expectedStringArray, String[] actualStringArray) {
        if (expectedStringArray != null) {
            Arrays.sort(expectedStringArray);
        }
        if (actualStringArray != null) {
            Arrays.sort(actualStringArray);
        }
        Assert.assertEquals(StringUtil.merge((Object[])expectedStringArray), StringUtil.merge((Object[])actualStringArray));
    }

    public static void assertLessThan(double expectedDouble, double actualDouble) throws Exception {
        if (actualDouble > expectedDouble) {
            Assert.fail(actualDouble + " is not less than " + expectedDouble);
        }
    }
}

