/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.test;

import com.liferay.portal.kernel.nio.intraband.BaseIntraband;
import com.liferay.portal.kernel.nio.intraband.CompletionHandler;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.DatagramHelper;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.test.MockRegistrationReference;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class MockIntraband
extends BaseIntraband {
    private Datagram _datagram;
    private IOException _ioException;
    private RegistrationReference _registrationReference;

    public MockIntraband() {
        this(10000L);
    }

    public MockIntraband(long defaultTimeout) {
        super(defaultTimeout);
    }

    public Datagram getDatagram() {
        return this._datagram;
    }

    public RegistrationReference getRegistrationReference() {
        return this._registrationReference;
    }

    public RegistrationReference registerChannel(Channel duplexChannel) {
        return new MockRegistrationReference((ScatteringByteChannel)duplexChannel, (GatheringByteChannel)duplexChannel);
    }

    public RegistrationReference registerChannel(ScatteringByteChannel scatteringByteChannel, GatheringByteChannel gatheringByteChannel) {
        return new MockRegistrationReference(scatteringByteChannel, gatheringByteChannel);
    }

    public void setIOException(IOException ioException) {
        this._ioException = ioException;
    }

    protected void doSendDatagram(RegistrationReference registrationReference, Datagram datagram) {
        this._registrationReference = registrationReference;
        this._datagram = datagram;
        CompletionHandler<Object> completionHandler = DatagramHelper.getCompletionHandler(datagram);
        if (completionHandler == null) {
            return;
        }
        if (this._ioException == null) {
            Datagram responseDatagram = this.processDatagram(datagram);
            if (responseDatagram != null) {
                completionHandler.replied(null, responseDatagram);
            }
        } else {
            completionHandler.failed(null, this._ioException);
        }
    }

    protected Datagram processDatagram(Datagram datagram) {
        return null;
    }
}

