/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband;

import com.liferay.portal.kernel.nio.intraband.CompletionHandler;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RecordCompletionHandler<A>
implements CompletionHandler<A> {
    private volatile A _attachment;
    private final CountDownLatch _deliveredCountDownLatch = new CountDownLatch(1);
    private final CountDownLatch _failedCountDownLatch = new CountDownLatch(1);
    private volatile IOException _ioe;
    private final CountDownLatch _repliedCountDownLatch = new CountDownLatch(1);
    private final CountDownLatch _submittedCountDownLatch = new CountDownLatch(1);
    private final CountDownLatch _timeoutedCountDownLatch = new CountDownLatch(1);

    public void delivered(A attachment) {
        this._attachment = attachment;
        this._deliveredCountDownLatch.countDown();
    }

    public void failed(A attachment, IOException ioe) {
        this._attachment = attachment;
        this._ioe = ioe;
        this._failedCountDownLatch.countDown();
    }

    public A getAttachment() {
        return this._attachment;
    }

    public IOException getIOException() {
        return this._ioe;
    }

    public void replied(A attachment, Datagram datagram) {
        this._attachment = attachment;
        this._repliedCountDownLatch.countDown();
    }

    public void submitted(A attachment) {
        this._attachment = attachment;
        this._submittedCountDownLatch.countDown();
    }

    public void timedOut(A attachment) {
        this._attachment = attachment;
        this._timeoutedCountDownLatch.countDown();
    }

    public void waitUntilDelivered() throws InterruptedException {
        this._deliveredCountDownLatch.await();
    }

    public void waitUntilFailed() throws InterruptedException {
        this._failedCountDownLatch.await();
    }

    public void waitUntilReplied() throws InterruptedException {
        this._repliedCountDownLatch.await();
    }

    public void waitUntilSubmitted() throws InterruptedException {
        this._submittedCountDownLatch.await();
    }

    public void waitUntilTimeouted() throws InterruptedException {
        this._timeoutedCountDownLatch.await();
    }

    public void waitUntilTimeouted(Selector selector) throws InterruptedException {
        while (!this._timeoutedCountDownLatch.await(10L, TimeUnit.MILLISECONDS)) {
            selector.wakeup();
        }
    }
}

