/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;

public class PathWrapper
implements Path {
    private final FileSystem _fileSystem;
    private final Path _path;

    public PathWrapper(Path path, FileSystem fileSystem) {
        this._path = path;
        this._fileSystem = fileSystem;
    }

    @Override
    public int compareTo(Path path) {
        return this._path.compareTo(PathWrapper.unwrapPath(path));
    }

    @Override
    public boolean endsWith(Path path) {
        return this._path.endsWith(PathWrapper.unwrapPath(path));
    }

    @Override
    public boolean endsWith(String path) {
        return this._path.endsWith(path);
    }

    @Override
    public boolean equals(Object path) {
        if (path instanceof PathWrapper) {
            PathWrapper pathWrapper = (PathWrapper)path;
            path = pathWrapper._path;
        }
        return this._path.equals(path);
    }

    @Override
    public Path getFileName() {
        return PathWrapper.wrapPath(this._path.getFileName(), this._fileSystem);
    }

    @Override
    public FileSystem getFileSystem() {
        return this._fileSystem;
    }

    @Override
    public Path getName(int index) {
        return PathWrapper.wrapPath(this._path.getName(index), this._fileSystem);
    }

    @Override
    public int getNameCount() {
        return this._path.getNameCount();
    }

    @Override
    public Path getParent() {
        return PathWrapper.wrapPath(this._path.getParent(), this._fileSystem);
    }

    @Override
    public Path getRoot() {
        return PathWrapper.wrapPath(this._path.getRoot(), this._fileSystem);
    }

    @Override
    public int hashCode() {
        return this._path.hashCode();
    }

    @Override
    public boolean isAbsolute() {
        return this._path.isAbsolute();
    }

    @Override
    public Iterator<Path> iterator() {
        final Iterator<Path> iterator = this._path.iterator();
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Path next() {
                return PathWrapper.wrapPath((Path)iterator.next(), PathWrapper.this._fileSystem);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public Path normalize() {
        return PathWrapper.wrapPath(this._path.normalize(), this._fileSystem);
    }

    @Override
    public WatchKey register(WatchService watcherService, WatchEvent.Kind<?> ... kinds) throws IOException {
        return this._path.register(watcherService, kinds);
    }

    @Override
    public WatchKey register(WatchService watcherService, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier ... modifiers) throws IOException {
        return this._path.register(watcherService, kinds, modifiers);
    }

    @Override
    public Path relativize(Path path) {
        return PathWrapper.wrapPath(this._path.relativize(PathWrapper.unwrapPath(path)), this._fileSystem);
    }

    @Override
    public Path resolve(Path path) {
        return PathWrapper.wrapPath(this._path.resolve(PathWrapper.unwrapPath(path)), this._fileSystem);
    }

    @Override
    public Path resolve(String path) {
        return PathWrapper.wrapPath(this._path.resolve(path), this._fileSystem);
    }

    @Override
    public Path resolveSibling(Path path) {
        return PathWrapper.wrapPath(this._path.resolveSibling(PathWrapper.unwrapPath(path)), this._fileSystem);
    }

    @Override
    public Path resolveSibling(String path) {
        return PathWrapper.wrapPath(this._path.resolveSibling(path), this._fileSystem);
    }

    @Override
    public boolean startsWith(Path path) {
        return this._path.startsWith(PathWrapper.unwrapPath(path));
    }

    @Override
    public boolean startsWith(String path) {
        return this._path.startsWith(path);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return PathWrapper.wrapPath(this._path.subpath(beginIndex, endIndex), this._fileSystem);
    }

    @Override
    public Path toAbsolutePath() {
        return PathWrapper.wrapPath(this._path.toAbsolutePath(), this._fileSystem);
    }

    @Override
    public File toFile() {
        return this._path.toFile();
    }

    @Override
    public Path toRealPath(LinkOption ... linkOptions) throws IOException {
        return PathWrapper.wrapPath(this._path.toRealPath(linkOptions), this._fileSystem);
    }

    @Override
    public String toString() {
        return this._path.toString();
    }

    @Override
    public URI toUri() {
        return this._path.toUri();
    }

    protected static Path unwrapPath(Path path) {
        if (path instanceof PathWrapper) {
            PathWrapper pathWrapper = (PathWrapper)path;
            path = pathWrapper._path;
        }
        return path;
    }

    protected static Path wrapPath(Path path, FileSystem fileSystem) {
        if (path == null) {
            return null;
        }
        return new PathWrapper(path, fileSystem);
    }
}

