/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio;

import com.liferay.portal.kernel.nio.PathWrapper;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Iterator;
import java.util.Set;

public class FileSystemWrapper
extends FileSystem {
    private final FileSystem _fileSystem;
    private final FileSystemProvider _fileSystemProvider;

    public FileSystemWrapper(FileSystem fileSystem, FileSystemProvider fileSystemProvider) {
        this._fileSystem = fileSystem;
        this._fileSystemProvider = fileSystemProvider;
    }

    @Override
    public void close() throws IOException {
        this._fileSystem.close();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this._fileSystem.getFileStores();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new PathWrapper(this._fileSystem.getPath(first, more), this);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return this._fileSystem.getPathMatcher(syntaxAndPattern);
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        Iterable<Path> iterable = this._fileSystem.getRootDirectories();
        final Iterator<Path> iterator = iterable.iterator();
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        return new PathWrapper((Path)iterator.next(), FileSystemWrapper.this);
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    @Override
    public String getSeparator() {
        return this._fileSystem.getSeparator();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this._fileSystem.getUserPrincipalLookupService();
    }

    @Override
    public boolean isOpen() {
        return this._fileSystem.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this._fileSystem.isReadOnly();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this._fileSystem.newWatchService();
    }

    @Override
    public FileSystemProvider provider() {
        return this._fileSystemProvider;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this._fileSystem.supportedFileAttributeViews();
    }
}

