/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent.test;

import java.util.concurrent.CountDownLatch;

public class MarkerBlockingJob
implements Runnable {
    private final boolean _blocking;
    private final CountDownLatch _blockingLatch = new CountDownLatch(1);
    private volatile boolean _ended;
    private final CountDownLatch _endedLatch = new CountDownLatch(1);
    private volatile boolean _interrupted;
    private volatile Thread _runThread;
    private volatile boolean _started;
    private final boolean _throwException;
    private final CountDownLatch _waitBlockingLatch = new CountDownLatch(1);

    public MarkerBlockingJob() {
        this(false);
    }

    public MarkerBlockingJob(boolean blocking) {
        this(blocking, false);
    }

    public MarkerBlockingJob(boolean blocking, boolean throwException) {
        this._blocking = blocking;
        this._throwException = throwException;
    }

    public Thread getRunThread() {
        return this._runThread;
    }

    public boolean isEnded() {
        return this._ended;
    }

    public boolean isInterrupted() {
        return this._interrupted;
    }

    public boolean isStarted() {
        return this._started;
    }

    @Override
    public void run() {
        this._runThread = Thread.currentThread();
        if (this._started) {
            throw new IllegalStateException("Job already started");
        }
        this._started = true;
        if (this._blocking) {
            this._waitBlockingLatch.countDown();
            try {
                this._blockingLatch.await();
            }
            catch (InterruptedException ie) {
                this._interrupted = true;
            }
        }
        if (this._throwException) {
            throw new RuntimeException();
        }
        this._ended = true;
        this._endedLatch.countDown();
    }

    public void unBlock() {
        this._blockingLatch.countDown();
    }

    public void waitUntilBlock() throws InterruptedException {
        if (!this._blocking) {
            throw new IllegalStateException("Blocking is not enabled");
        }
        this._waitBlockingLatch.await();
    }

    public void waitUntilEnded() throws InterruptedException {
        this._endedLatch.await();
    }
}

