/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.OrganizationDisplayTerms;
import com.liferay.portlet.usersadmin.search.OrganizationSearchTerms;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class OrganizationSearch
extends SearchContainer<Organization> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-organizations-were-found";
    public static List<String> headerNames = new ArrayList<String>();
    public static Map<String, String> orderableHeaders = new HashMap<String, String>();
    private static final Log _log;

    public OrganizationSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        this(portletRequest, "cur", iteratorURL);
    }

    public OrganizationSearch(PortletRequest portletRequest, String curParam, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new OrganizationDisplayTerms(portletRequest), (DisplayTerms)new OrganizationSearchTerms(portletRequest), curParam, DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        OrganizationDisplayTerms displayTerms = (OrganizationDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("city", displayTerms.getCity());
        iteratorURL.setParameter("countryId", String.valueOf(displayTerms.getCountryId()));
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("parentOrganizationId", String.valueOf(displayTerms.getParentOrganizationId()));
        iteratorURL.setParameter("regionId", String.valueOf(displayTerms.getRegionId()));
        iteratorURL.setParameter("street", displayTerms.getStreet());
        iteratorURL.setParameter("type", displayTerms.getType());
        iteratorURL.setParameter("zip", displayTerms.getZip());
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue(portletId, "organizations-order-by-col", orderByCol);
                preferences.setValue(portletId, "organizations-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "organizations-order-by-col", "name");
                orderByType = preferences.getValue(portletId, "organizations-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = UsersAdminUtil.getOrganizationOrderByComparator((String)orderByCol, (String)orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
    }

    static {
        headerNames.add("name");
        headerNames.add("parent-organization");
        headerNames.add("type");
        headerNames.add("city");
        headerNames.add("region");
        headerNames.add("country");
        orderableHeaders.put("name", "name");
        orderableHeaders.put("type", "type");
        _log = LogFactoryUtil.getLog(OrganizationSearch.class);
    }
}

