/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.LockProtectedAction;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.social.model.impl.SocialActivityImpl;
import com.liferay.portlet.social.service.base.SocialActivityCounterLocalServiceBaseImpl;
import com.liferay.social.kernel.model.SocialAchievement;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityCounter;
import com.liferay.social.kernel.model.SocialActivityCounterDefinition;
import com.liferay.social.kernel.model.SocialActivityDefinition;
import com.liferay.social.kernel.model.SocialActivityLimit;
import com.liferay.social.kernel.model.SocialActivityProcessor;
import com.liferay.social.kernel.service.persistence.SocialActivityCounterFinder;
import com.liferay.social.kernel.util.SocialCounterPeriodUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SocialActivityCounterLocalServiceImpl
extends SocialActivityCounterLocalServiceBaseImpl {
    private final SocialActivityCounterDefinition _assetActivitiesActivityCounterDefinition = new SocialActivityCounterDefinition("asset.activities", 2);
    private final SocialActivityCounterDefinition _userAchievementsActivityCounterDefinition = new SocialActivityCounterDefinition("user.achievements", 1);
    private final SocialActivityCounterDefinition _userActivitiesActivityCounterDefinition = new SocialActivityCounterDefinition("user.activities", 1);

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public SocialActivityCounter addActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType, int totalValue, long previousActivityCounterId, int periodLength) throws PortalException {
        SocialActivityCounter activityCounter = null;
        if (previousActivityCounterId != 0L) {
            activityCounter = this.socialActivityCounterPersistence.findByPrimaryKey(previousActivityCounterId);
            if (periodLength == 0) {
                activityCounter.setEndPeriod(SocialCounterPeriodUtil.getStartPeriod() - 1);
            } else {
                activityCounter.setEndPeriod(activityCounter.getStartPeriod() + periodLength - 1);
            }
            this.socialActivityCounterPersistence.update((BaseModel)activityCounter);
        }
        if ((activityCounter = this.socialActivityCounterPersistence.fetchByG_C_C_N_O_E(groupId, classNameId, classPK, name, ownerType, -1, false)) != null) {
            return activityCounter;
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long activityCounterId = this.counterLocalService.increment();
        activityCounter = this.socialActivityCounterPersistence.create(activityCounterId);
        activityCounter.setGroupId(groupId);
        activityCounter.setCompanyId(group.getCompanyId());
        activityCounter.setClassNameId(classNameId);
        activityCounter.setClassPK(classPK);
        activityCounter.setName(name);
        activityCounter.setOwnerType(ownerType);
        activityCounter.setTotalValue(totalValue);
        if (periodLength == 0) {
            activityCounter.setStartPeriod(SocialCounterPeriodUtil.getStartPeriod());
        } else {
            activityCounter.setStartPeriod(SocialCounterPeriodUtil.getActivityDay());
        }
        activityCounter.setEndPeriod(-1);
        activityCounter.setActive(true);
        this.socialActivityCounterPersistence.update((BaseModel)activityCounter);
        return activityCounter;
    }

    public void addActivityCounters(SocialActivity activity) throws PortalException {
        if (!this.socialActivitySettingLocalService.isEnabled(activity.getGroupId(), activity.getClassNameId())) {
            return;
        }
        if (!this.socialActivitySettingLocalService.isEnabled(activity.getGroupId(), activity.getClassNameId(), activity.getClassPK())) {
            return;
        }
        if (activity.getType() == 10009 || activity.getType() == 10007) {
            this.disableActivityCounters(activity.getClassNameId(), activity.getClassPK());
            return;
        }
        if (activity.getType() == 10010 || activity.getType() == 10008) {
            this.enableActivityCounters(activity.getClassNameId(), activity.getClassPK());
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(activity.getUserId());
        SocialActivityDefinition activityDefinition = this.socialActivitySettingLocalService.getActivityDefinition(activity.getGroupId(), activity.getClassName(), activity.getType());
        if (activityDefinition == null || !activityDefinition.isCountersEnabled()) {
            return;
        }
        SocialActivityProcessor activityProcessor = activityDefinition.getActivityProcessor();
        if (activityProcessor != null) {
            activityProcessor.processActivity(activity);
        }
        AssetEntry assetEntry = activity.getAssetEntry();
        User assetEntryUser = this.userPersistence.findByPrimaryKey(assetEntry.getUserId());
        ArrayList<SocialActivityCounter> activityCounters = new ArrayList<SocialActivityCounter>();
        for (SocialActivityCounterDefinition activityCounterDefinition : activityDefinition.getActivityCounterDefinitions()) {
            if (!this.isAddActivityCounter(user, assetEntryUser, assetEntry, activityCounterDefinition)) continue;
            SocialActivityCounter activityCounter = this.addActivityCounter(activity.getGroupId(), user, activity, activityCounterDefinition);
            activityCounters.add(activityCounter);
        }
        SocialActivityCounter assetActivitiesCounter = null;
        if (!assetEntryUser.isDefaultUser() && assetEntryUser.isActive() && assetEntry.isVisible()) {
            assetActivitiesCounter = this.addAssetActivitiesCounter(activity);
        }
        SocialActivityCounter userActivitiesCounter = null;
        if (!user.isDefaultUser() && user.isActive()) {
            userActivitiesCounter = this.addUserActivitiesCounter(activity);
        }
        for (SocialActivityCounter activityCounter : activityCounters) {
            SocialActivityCounterDefinition activityCounterDefinition = activityDefinition.getActivityCounterDefinition(activityCounter.getName());
            if (!this.checkActivityLimit(user, activity, activityCounterDefinition)) continue;
            this.incrementActivityCounter(activityCounter, activityCounterDefinition);
        }
        if (assetActivitiesCounter != null) {
            this.incrementActivityCounter(assetActivitiesCounter, this._assetActivitiesActivityCounterDefinition);
        }
        if (userActivitiesCounter != null) {
            this.incrementActivityCounter(userActivitiesCounter, this._userActivitiesActivityCounterDefinition);
        }
        for (SocialAchievement achievement : activityDefinition.getAchievements()) {
            achievement.processActivity(activity);
        }
    }

    public void deleteActivityCounters(AssetEntry assetEntry) throws PortalException {
        if (assetEntry == null) {
            return;
        }
        this.adjustUserContribution(assetEntry, false);
        this.socialActivityCounterPersistence.removeByC_C(assetEntry.getClassNameId(), assetEntry.getClassPK());
        this.socialActivityLimitPersistence.removeByC_C(assetEntry.getClassNameId(), assetEntry.getClassPK());
        this.socialActivitySettingLocalService.deleteActivitySetting(assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK());
        this.clearFinderCache();
    }

    public void deleteActivityCounters(long classNameId, long classPK) throws PortalException {
        String className = PortalUtil.getClassName((long)classNameId);
        if (!className.equals(User.class.getName())) {
            AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK);
            this.deleteActivityCounters(assetEntry);
        } else {
            this.socialActivityCounterPersistence.removeByC_C(classNameId, classPK);
            this.socialActivityLimitPersistence.removeByUserId(classPK);
        }
        this.clearFinderCache();
    }

    public void deleteActivityCounters(String className, long classPK) throws PortalException {
        if (!className.equals(User.class.getName())) {
            AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK);
            this.deleteActivityCounters(assetEntry);
        } else {
            long classNameId = this.classNameLocalService.getClassNameId(className);
            this.socialActivityCounterPersistence.removeByC_C(classNameId, classPK);
            this.socialActivityLimitPersistence.removeByUserId(classPK);
        }
        this.clearFinderCache();
    }

    public void disableActivityCounters(long classNameId, long classPK) throws PortalException {
        String className = PortalUtil.getClassName((long)classNameId);
        this.disableActivityCounters(className, classPK);
    }

    public void disableActivityCounters(String className, long classPK) throws PortalException {
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry == null) {
            return;
        }
        List activityCounters = this.socialActivityCounterPersistence.findByC_C(assetEntry.getClassNameId(), classPK);
        this.adjustUserContribution(assetEntry, false);
        for (SocialActivityCounter activityCounter : activityCounters) {
            if (!activityCounter.isActive()) continue;
            activityCounter.setActive(false);
            this.socialActivityCounterPersistence.update((BaseModel)activityCounter);
        }
        this.clearFinderCache();
    }

    public void enableActivityCounters(long classNameId, long classPK) throws PortalException {
        String className = PortalUtil.getClassName((long)classNameId);
        this.enableActivityCounters(className, classPK);
    }

    public void enableActivityCounters(String className, long classPK) throws PortalException {
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry == null) {
            return;
        }
        List activityCounters = this.socialActivityCounterPersistence.findByC_C(assetEntry.getClassNameId(), classPK);
        this.adjustUserContribution(assetEntry, true);
        for (SocialActivityCounter activityCounter : activityCounters) {
            if (activityCounter.isActive()) continue;
            activityCounter.setActive(true);
            this.socialActivityCounterPersistence.update((BaseModel)activityCounter);
        }
        this.clearFinderCache();
    }

    public SocialActivityCounter fetchActivityCounterByEndPeriod(long groupId, long classNameId, long classPK, String name, int ownerType, int endPeriod) {
        return this.socialActivityCounterPersistence.fetchByG_C_C_N_O_E(groupId, classNameId, classPK, name, ownerType, endPeriod);
    }

    public SocialActivityCounter fetchActivityCounterByStartPeriod(long groupId, long classNameId, long classPK, String name, int ownerType, int startPeriod) {
        return this.socialActivityCounterPersistence.fetchByG_C_C_N_O_S(groupId, classNameId, classPK, name, ownerType, startPeriod);
    }

    public SocialActivityCounter fetchLatestActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType) {
        return this.socialActivityCounterPersistence.fetchByG_C_C_N_O_E(groupId, classNameId, classPK, name, ownerType, -1);
    }

    public List<SocialActivityCounter> getOffsetActivityCounters(long groupId, String name, int startOffset, int endOffset) {
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod((int)startOffset);
        int endPeriod = SocialCounterPeriodUtil.getEndPeriod((int)endOffset);
        return this.getPeriodActivityCounters(groupId, name, startPeriod, endPeriod);
    }

    public List<SocialActivityCounter> getOffsetDistributionActivityCounters(long groupId, String name, int startOffset, int endOffset) {
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod((int)startOffset);
        int endPeriod = SocialCounterPeriodUtil.getEndPeriod((int)endOffset);
        return this.getPeriodDistributionActivityCounters(groupId, name, startPeriod, endPeriod);
    }

    public List<SocialActivityCounter> getPeriodActivityCounters(long groupId, String name, int startPeriod, int endPeriod) {
        if (endPeriod == -1) {
            endPeriod = SocialCounterPeriodUtil.getEndPeriod();
        }
        int offset = SocialCounterPeriodUtil.getOffset((int)endPeriod);
        int periodLength = SocialCounterPeriodUtil.getPeriodLength((int)offset);
        return this.socialActivityCounterFinder.findAC_ByG_N_S_E_1(groupId, name, startPeriod, endPeriod, periodLength);
    }

    public List<SocialActivityCounter> getPeriodDistributionActivityCounters(long groupId, String name, int startPeriod, int endPeriod) {
        int offset = SocialCounterPeriodUtil.getOffset((int)endPeriod);
        int periodLength = SocialCounterPeriodUtil.getPeriodLength((int)offset);
        return this.socialActivityCounterFinder.findAC_ByG_N_S_E_2(groupId, name, startPeriod, endPeriod, periodLength);
    }

    public List<Tuple> getUserActivityCounters(long groupId, String[] rankingNames, String[] selectedNames, int start, int end) {
        List userIds = this.socialActivityCounterFinder.findU_ByG_N(groupId, rankingNames, start, end);
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        Tuple[] userActivityCounters = new Tuple[userIds.size()];
        List activityCounters = this.socialActivityCounterFinder.findAC_By_G_C_C_N_S_E(groupId, userIds, selectedNames, -1, -1);
        long userId = 0L;
        HashMap<String, SocialActivityCounter> activityCountersMap = null;
        for (SocialActivityCounter activityCounter : activityCounters) {
            if (userId != activityCounter.getClassPK()) {
                userId = activityCounter.getClassPK();
                activityCountersMap = new HashMap<String, SocialActivityCounter>();
                Tuple userActivityCounter = new Tuple(new Object[]{userId, activityCountersMap});
                for (int i = 0; i < userIds.size(); ++i) {
                    long curUserId = (Long)userIds.get(i);
                    if (userId != curUserId) continue;
                    userActivityCounters[i] = userActivityCounter;
                    break;
                }
            }
            activityCountersMap.put(activityCounter.getName(), activityCounter);
        }
        return Arrays.asList(userActivityCounters);
    }

    public int getUserActivityCountersCount(long groupId, String[] rankingNames) {
        return this.socialActivityCounterFinder.countU_ByG_N(groupId, rankingNames);
    }

    public void incrementUserAchievementCounter(long userId, long groupId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        SocialActivityCounter activityCounter = this.addActivityCounter(groupId, user, new SocialActivityImpl(), this._userAchievementsActivityCounterDefinition);
        this.incrementActivityCounter(activityCounter, this._userAchievementsActivityCounterDefinition);
    }

    protected SocialActivityCounter addActivityCounter(long groupId, User user, SocialActivity activity, SocialActivityCounterDefinition activityCounterDefinition) throws PortalException {
        SocialActivityLimit activityLimit;
        long classPK;
        int ownerType = activityCounterDefinition.getOwnerType();
        long classNameId = this.getClassNameId(activity.getAssetEntry(), ownerType);
        SocialActivityCounter activityCounter = this.fetchLatestActivityCounter(groupId, classNameId, classPK = this.getClassPK(user, activity.getAssetEntry(), ownerType), activityCounterDefinition.getName(), ownerType);
        if (activityCounter == null) {
            activityCounter = this.lockProtectedAddActivityCounter(groupId, classNameId, classPK, activityCounterDefinition.getName(), ownerType, 0, 0L, activityCounterDefinition.getPeriodLength());
        } else if (!activityCounter.isActivePeriod(activityCounterDefinition.getPeriodLength())) {
            activityCounter = this.lockProtectedAddActivityCounter(groupId, classNameId, classPK, activityCounterDefinition.getName(), ownerType, activityCounter.getTotalValue(), activityCounter.getActivityCounterId(), activityCounterDefinition.getPeriodLength());
        }
        if (activityCounterDefinition.getLimitValue() > 0 && (activityLimit = this.socialActivityLimitPersistence.fetchByG_U_C_C_A_A(groupId, user.getUserId(), activity.getClassNameId(), this.getLimitClassPK(activity, activityCounterDefinition), activity.getType(), activityCounterDefinition.getName())) == null) {
            this.lockProtectedGetActivityLimit(groupId, user, activity, activityCounterDefinition);
        }
        return activityCounter;
    }

    protected SocialActivityCounter addAssetActivitiesCounter(SocialActivity activity) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(activity.getUserId());
        return this.addActivityCounter(activity.getGroupId(), user, activity, this._assetActivitiesActivityCounterDefinition);
    }

    protected SocialActivityCounter addUserActivitiesCounter(SocialActivity activity) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(activity.getUserId());
        return this.addActivityCounter(activity.getGroupId(), user, activity, this._userActivitiesActivityCounterDefinition);
    }

    protected void adjustUserContribution(AssetEntry assetEntry, boolean enable) throws PortalException {
        SocialActivityCounter latestContributionActivityCounter;
        if (assetEntry == null) {
            return;
        }
        SocialActivityCounter latestPopularityActivityCounter = this.fetchLatestActivityCounter(assetEntry.getGroupId(), assetEntry.getClassNameId(), assetEntry.getClassPK(), "popularity", 2);
        if (latestPopularityActivityCounter == null || enable && latestPopularityActivityCounter.isActive() || !enable && !latestPopularityActivityCounter.isActive()) {
            return;
        }
        int factor = -1;
        if (enable) {
            factor = 1;
        }
        if ((latestContributionActivityCounter = this.fetchLatestActivityCounter(assetEntry.getGroupId(), this.classNameLocalService.getClassNameId(User.class.getName()), assetEntry.getUserId(), "contribution", 3)) == null) {
            return;
        }
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod();
        if (latestContributionActivityCounter.getStartPeriod() != startPeriod) {
            latestContributionActivityCounter = this.addActivityCounter(latestContributionActivityCounter.getGroupId(), latestContributionActivityCounter.getClassNameId(), latestContributionActivityCounter.getClassPK(), latestContributionActivityCounter.getName(), latestContributionActivityCounter.getOwnerType(), latestContributionActivityCounter.getTotalValue(), latestContributionActivityCounter.getActivityCounterId(), 0);
        }
        if (latestPopularityActivityCounter.getStartPeriod() == startPeriod) {
            latestContributionActivityCounter.setCurrentValue(latestContributionActivityCounter.getCurrentValue() + latestPopularityActivityCounter.getCurrentValue() * factor);
        }
        latestContributionActivityCounter.setTotalValue(latestContributionActivityCounter.getTotalValue() + latestPopularityActivityCounter.getTotalValue() * factor);
        this.socialActivityCounterPersistence.update((BaseModel)latestContributionActivityCounter);
    }

    protected boolean checkActivityLimit(User user, SocialActivity activity, SocialActivityCounterDefinition activityCounterDefinition) throws PortalException {
        SocialActivityLimit activityLimit;
        int count;
        if (activityCounterDefinition.getLimitValue() == 0) {
            return true;
        }
        long classPK = activity.getClassPK();
        String name = activityCounterDefinition.getName();
        if (name.equals("participation")) {
            classPK = 0L;
        }
        if ((count = (activityLimit = this.socialActivityLimitPersistence.findByG_U_C_C_A_A(activity.getGroupId(), user.getUserId(), activity.getClassNameId(), classPK, activity.getType(), name)).getCount(activityCounterDefinition.getLimitPeriod())) < activityCounterDefinition.getLimitValue()) {
            activityLimit.setCount(activityCounterDefinition.getLimitPeriod(), count + 1);
            this.socialActivityLimitPersistence.update((BaseModel)activityLimit);
            return true;
        }
        return false;
    }

    protected void clearFinderCache() {
        PortalCache portalCache = MultiVMPoolUtil.getPortalCache((String)SocialActivityCounterFinder.class.getName());
        portalCache.removeAll();
    }

    protected long getClassNameId(AssetEntry assetEntry, int ownerType) {
        if (ownerType == 2) {
            return assetEntry.getClassNameId();
        }
        return this.classNameLocalService.getClassNameId(User.class.getName());
    }

    protected long getClassPK(User user, AssetEntry assetEntry, int ownerType) {
        if (ownerType == 1) {
            return user.getUserId();
        }
        if (ownerType == 2) {
            return assetEntry.getClassPK();
        }
        return assetEntry.getUserId();
    }

    protected long getLimitClassPK(SocialActivity activity, SocialActivityCounterDefinition activityCounterDefinition) {
        String name = activityCounterDefinition.getName();
        if (name.equals("participation")) {
            return 0L;
        }
        return activity.getClassPK();
    }

    protected void incrementActivityCounter(SocialActivityCounter activityCounter, SocialActivityCounterDefinition activityCounterDefinition) {
        activityCounter.setCurrentValue(activityCounter.getCurrentValue() + activityCounterDefinition.getIncrement());
        activityCounter.setTotalValue(activityCounter.getTotalValue() + activityCounterDefinition.getIncrement());
        this.socialActivityCounterPersistence.update((BaseModel)activityCounter);
        this.socialActivityCounterPersistence.clearCache((BaseModel)activityCounter);
    }

    protected boolean isAddActivityCounter(User user, User assetEntryUser, AssetEntry assetEntry, SocialActivityCounterDefinition activityCounterDefinition) {
        if ((user.isDefaultUser() || !user.isActive()) && activityCounterDefinition.getOwnerType() != 2) {
            return false;
        }
        if ((assetEntryUser.isDefaultUser() || !assetEntryUser.isActive()) && activityCounterDefinition.getOwnerType() != 1) {
            return false;
        }
        if (!activityCounterDefinition.isEnabled() || activityCounterDefinition.getIncrement() == 0) {
            return false;
        }
        String name = activityCounterDefinition.getName();
        if (user.getUserId() == assetEntryUser.getUserId() && (name.equals("contribution") || name.equals("popularity"))) {
            return false;
        }
        return activityCounterDefinition.getOwnerType() != 2 || assetEntry.isVisible();
    }

    protected SocialActivityCounter lockProtectedAddActivityCounter(final long groupId, final long classNameId, final long classPK, final String name, final int ownerType, final int totalValue, final long previousActivityCounterId, final int periodLength) throws PortalException {
        String lockKey = StringUtil.merge((Object[])new Object[]{groupId, classNameId, classPK, name, ownerType}, (String)"#");
        LockProtectedAction<SocialActivityCounter> lockProtectedAction = new LockProtectedAction<SocialActivityCounter>(SocialActivityCounter.class, lockKey, PropsValues.SOCIAL_ACTIVITY_LOCK_TIMEOUT, PropsValues.SOCIAL_ACTIVITY_LOCK_RETRY_DELAY){

            protected SocialActivityCounter performProtectedAction() throws PortalException {
                SocialActivityCounter activityCounter = SocialActivityCounterLocalServiceImpl.this.socialActivityCounterLocalService.addActivityCounter(groupId, classNameId, classPK, name, ownerType, totalValue, previousActivityCounterId, periodLength);
                return activityCounter;
            }
        };
        lockProtectedAction.performAction();
        return (SocialActivityCounter)lockProtectedAction.getReturnValue();
    }

    protected void lockProtectedGetActivityLimit(final long groupId, final User user, final SocialActivity activity, final SocialActivityCounterDefinition activityCounterDefinition) throws PortalException {
        final long classPK = this.getLimitClassPK(activity, activityCounterDefinition);
        String lockKey = StringUtil.merge((Object[])new Object[]{groupId, user.getUserId(), activity.getClassNameId(), classPK, activity.getType(), activityCounterDefinition.getName()}, (String)"#");
        LockProtectedAction<SocialActivityLimit> lockProtectedAction = new LockProtectedAction<SocialActivityLimit>(SocialActivityLimit.class, lockKey, PropsValues.SOCIAL_ACTIVITY_LOCK_TIMEOUT, PropsValues.SOCIAL_ACTIVITY_LOCK_RETRY_DELAY){

            protected SocialActivityLimit performProtectedAction() throws PortalException {
                SocialActivityLimit activityLimit = SocialActivityCounterLocalServiceImpl.this.socialActivityLimitPersistence.fetchByG_U_C_C_A_A(groupId, user.getUserId(), activity.getClassNameId(), classPK, activity.getType(), activityCounterDefinition.getName());
                if (activityLimit == null) {
                    activityLimit = SocialActivityCounterLocalServiceImpl.this.socialActivityLimitLocalService.addActivityLimit(user.getUserId(), activity.getGroupId(), activity.getClassNameId(), classPK, activity.getType(), activityCounterDefinition.getName(), activityCounterDefinition.getLimitPeriod());
                }
                return activityLimit;
            }
        };
        lockProtectedAction.performAction();
        this.socialActivityLimitPersistence.cacheResult((SocialActivityLimit)lockProtectedAction.getReturnValue());
    }
}

