/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.search;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class OrganizationRoleUserChecker
extends RowChecker {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationRoleUserChecker.class);
    private final Organization _organization;
    private final Role _role;

    public OrganizationRoleUserChecker(RenderResponse renderResponse, Organization organization, Role role) {
        super((PortletResponse)renderResponse);
        this._organization = organization;
        this._role = role;
    }

    public boolean isChecked(Object obj) {
        User user = (User)obj;
        try {
            return UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)user.getUserId(), (long)this._organization.getGroupId(), (long)this._role.getRoleId());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return false;
        }
    }

    public boolean isDisabled(Object obj) {
        User user = (User)obj;
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (this.isChecked(user) ? OrganizationMembershipPolicyUtil.isRoleProtected((PermissionChecker)permissionChecker, (long)user.getUserId(), (long)this._organization.getOrganizationId(), (long)this._role.getRoleId()) || OrganizationMembershipPolicyUtil.isRoleRequired((long)user.getUserId(), (long)this._organization.getOrganizationId(), (long)this._role.getRoleId()) : !OrganizationMembershipPolicyUtil.isRoleAllowed((long)user.getUserId(), (long)this._organization.getOrganizationId(), (long)this._role.getRoleId())) {
                return true;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return super.isDisabled(obj);
    }
}

