/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.expando.kernel.util.ExpandoBridgeIndexerUtil;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.trash.kernel.util.TrashUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@OSGiBeanProperties
public class DLFileEntryIndexer
extends BaseIndexer<DLFileEntry>
implements RelatedEntryIndexer {
    public static final String CLASS_NAME = DLFileEntry.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryIndexer.class);
    private final RelatedEntryIndexer _relatedEntryIndexer = new BaseRelatedEntryIndexer();

    public DLFileEntryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "companyId", "content", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedClassNames(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this._relatedEntryIndexer.addRelatedClassNames(contextBooleanFilter, searchContext);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        Comment comment = (Comment)obj;
        FileEntry fileEntry = null;
        try {
            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)comment.getClassPK());
        }
        catch (Exception e2) {
            return;
        }
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
        }
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)classPK);
        FileVersion fileVersion = fileEntry.getFileVersion();
        return this.isVisible(fileVersion.getStatus(), status);
    }

    public boolean isVisibleRelatedEntry(long classPK, int status) throws Exception {
        DLFileEntry dlFileEntry;
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)classPK);
        if (fileEntry instanceof LiferayFileEntry && (dlFileEntry = (DLFileEntry)fileEntry.getModel()).isInHiddenFolder()) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)dlFileEntry.getClassName());
            return indexer.isVisible(dlFileEntry.getClassPK(), status);
        }
        return true;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Object[] mimeTypes;
        this.addStatus(contextBooleanFilter, searchContext);
        if (searchContext.isIncludeAttachments()) {
            this.addRelatedClassNames(contextBooleanFilter, searchContext);
        }
        if (ArrayUtil.contains((long[])searchContext.getFolderIds(), (long)0L)) {
            contextBooleanFilter.addRequiredTerm("hidden", searchContext.isIncludeAttachments());
        }
        this.addSearchClassTypeIds(contextBooleanFilter, searchContext);
        String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            block7: {
                String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
                DDMStructure ddmStructure = DDMStructureManagerUtil.getStructure((long)GetterUtil.getLong((String)ddmStructureFieldNameParts[2]));
                String fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)searchContext.getLocale())), (String)"");
                try {
                    ddmStructureFieldValue = DDMStructureManagerUtil.getIndexedFieldValue((Serializable)ddmStructureFieldValue, (String)ddmStructure.getFieldType(fieldName));
                }
                catch (Exception e2) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)e2, (Throwable)e2);
                }
            }
            BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
            booleanQuery.addRequiredTerm(ddmStructureFieldName, "\"" + ddmStructureFieldValue + "\"");
            contextBooleanFilter.add((Filter)new QueryFilter((Query)booleanQuery), BooleanClauseOccur.MUST);
        }
        if (ArrayUtil.isNotEmpty((Object[])(mimeTypes = (String[])searchContext.getAttribute("mimeTypes")))) {
            BooleanFilter mimeTypesBooleanFilter = new BooleanFilter();
            for (Object mimeType : mimeTypes) {
                mimeTypesBooleanFilter.addTerm("mimeType", StringUtil.replace((String)mimeType, (char)'/', (char)'_'));
            }
            contextBooleanFilter.add((Filter)mimeTypesBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            this.addSearchTerm(searchQuery, searchContext, "description", false);
            this.addSearchTerm(searchQuery, searchContext, "title", false);
            this.addSearchTerm(searchQuery, searchContext, "userName", false);
        }
        this.addSearchTerm(searchQuery, searchContext, "ddmContent", false);
        this.addSearchTerm(searchQuery, searchContext, "extension", false);
        this.addSearchTerm(searchQuery, searchContext, "fileEntryTypeId", false);
        this.addSearchTerm(searchQuery, searchContext, "path", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    public void updateFullQuery(SearchContext searchContext) {
        if (searchContext.isIncludeAttachments()) {
            searchContext.addFullQueryEntryClassName(DLFileEntry.class.getName());
        }
    }

    protected void addFileEntryTypeAttributes(Document document, DLFileVersion dlFileVersion) throws PortalException {
        List dlFileEntryMetadatas = DLFileEntryMetadataLocalServiceUtil.getFileVersionFileEntryMetadatas((long)dlFileVersion.getFileVersionId());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            DDMFormValues ddmFormValues = null;
            try {
                ddmFormValues = StorageEngineManagerUtil.getDDMFormValues((long)dlFileEntryMetadata.getDDMStorageId());
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (ddmFormValues == null) continue;
            DDMStructureManagerUtil.addAttributes((long)dlFileEntryMetadata.getDDMStructureId(), (Document)document, (DDMFormValues)ddmFormValues);
        }
    }

    protected void doDelete(DLFileEntry dlFileEntry) throws Exception {
        this.deleteDocument(dlFileEntry.getCompanyId(), dlFileEntry.getFileEntryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document doGetDocument(DLFileEntry dlFileEntry) throws Exception {
        InputStream is;
        boolean indexContent;
        block22: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Indexing document " + dlFileEntry));
            }
            indexContent = true;
            is = null;
            try {
                Object[] ignoreExtensions = PrefsPropsUtil.getStringArray("dl.file.indexing.ignore.extensions", ",");
                if (ArrayUtil.contains((Object[])ignoreExtensions, (Object)("." + dlFileEntry.getExtension()))) {
                    indexContent = false;
                }
                if (indexContent) {
                    is = dlFileEntry.getFileVersion().getContentStream(false);
                }
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) break block22;
                _log.debug((Object)"Error retrieving document stream", (Throwable)e2);
            }
        }
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        try {
            Indexer indexer;
            Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)dlFileEntry, (BaseModel)dlFileVersion);
            if (indexContent) {
                if (is != null) {
                    try {
                        document.addFile("content", is, dlFileEntry.getTitle(), PropsValues.DL_FILE_INDEXING_MAX_SIZE);
                    }
                    catch (IOException ioe) {
                        throw new SearchException("Cannot extract text from file" + dlFileEntry);
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Document " + dlFileEntry + " does not have any content"));
                }
            }
            document.addKeyword("classTypeId", dlFileEntry.getFileEntryTypeId());
            document.addText("description", dlFileEntry.getDescription());
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addText("properties", dlFileEntry.getLuceneProperties());
            String title = dlFileEntry.getTitle();
            if (dlFileEntry.isInTrash()) {
                title = TrashUtil.getOriginalTitle((String)title);
            }
            document.addText("title", title);
            document.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
            document.addKeyword("dataRepositoryId", dlFileEntry.getDataRepositoryId());
            document.addText("ddmContent", this.extractDDMContent(dlFileVersion, LocaleUtil.getSiteDefault()));
            document.addKeyword("extension", dlFileEntry.getExtension());
            document.addKeyword("fileEntryTypeId", dlFileEntry.getFileEntryTypeId());
            document.addKeyword("mimeType", StringUtil.replace((String)dlFileEntry.getMimeType(), (char)'/', (char)'_'));
            document.addKeyword("path", dlFileEntry.getTitle());
            document.addKeyword("readCount", dlFileEntry.getReadCount());
            document.addKeyword("size", dlFileEntry.getSize());
            ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)dlFileEntry.getCompanyId(), (String)DLFileEntry.class.getName(), (long)dlFileVersion.getFileVersionId());
            ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
            this.addFileEntryTypeAttributes(document, dlFileVersion);
            if (dlFileEntry.isInHiddenFolder() && (indexer = IndexerRegistryUtil.getIndexer((String)dlFileEntry.getClassName())) != null && indexer instanceof RelatedEntryIndexer) {
                RelatedEntryIndexer relatedEntryIndexer = (RelatedEntryIndexer)indexer;
                relatedEntryIndexer.addRelatedEntryFields(document, (Object)new LiferayFileEntry(dlFileEntry));
                DocumentHelper documentHelper = new DocumentHelper(document);
                documentHelper.setAttachmentOwnerKey(PortalUtil.getClassNameId((String)dlFileEntry.getClassName()), dlFileEntry.getClassPK());
                document.addKeyword("relatedEntry", true);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + dlFileEntry + " indexed successfully"));
            }
            Document document2 = document;
            return document2;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(DLFileEntry dlFileEntry) throws Exception {
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        if (!dlFileVersion.isApproved() && !dlFileEntry.isInTrash()) {
            return;
        }
        Document document = this.getDocument(dlFileEntry);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)dlFileEntry.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)classPK);
        this.doReindex(dlFileEntry);
    }

    protected void doReindex(String[] ids) throws Exception {
        if (ids.length == 1) {
            long companyId = GetterUtil.getLong((String)ids[0]);
            this.reindexFolders(companyId);
            this.reindexRoot(companyId);
        } else {
            long companyId = GetterUtil.getLong((String)ids[0]);
            long groupId = GetterUtil.getLong((String)ids[1]);
            long dataRepositoryId = GetterUtil.getLong((String)ids[2]);
            this.reindexFileEntries(companyId, groupId, dataRepositoryId);
        }
    }

    protected String extractDDMContent(DLFileVersion dlFileVersion, Locale locale) throws Exception {
        List dlFileEntryMetadatas = DLFileEntryMetadataLocalServiceUtil.getFileVersionFileEntryMetadatas((long)dlFileVersion.getFileVersionId());
        StringBundler sb = new StringBundler(dlFileEntryMetadatas.size());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            DDMFormValues ddmFormValues = null;
            try {
                ddmFormValues = StorageEngineManagerUtil.getDDMFormValues((long)dlFileEntryMetadata.getDDMStorageId());
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (ddmFormValues == null) continue;
            sb.append(DDMStructureManagerUtil.extractAttributes((long)dlFileEntryMetadata.getDDMStructureId(), (DDMFormValues)ddmFormValues, (Locale)locale));
        }
        return sb.toString();
    }

    protected void reindexFileEntries(long companyId, final long groupId, final long dataRepositoryId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = DLFileEntryLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"folderId");
                long folderId = DLFolderConstants.getFolderId((long)groupId, (long)dataRepositoryId);
                dynamicQuery.add(property.eq((Object)folderId));
            }
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setGroupId(groupId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFileEntry>(){

            public void performAction(DLFileEntry dlFileEntry) {
                block2: {
                    try {
                        Document document = DLFileEntryIndexer.this.getDocument(dlFileEntry);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index document library file entry " + dlFileEntry.getFileEntryId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void reindexFolders(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = DLFolderLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFolder>(){

            public void performAction(DLFolder dlFolder) throws PortalException {
                long groupId = dlFolder.getGroupId();
                long folderId = dlFolder.getFolderId();
                String[] newIds = new String[]{String.valueOf(companyId), String.valueOf(groupId), String.valueOf(folderId)};
                DLFileEntryIndexer.this.reindex(newIds);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Group>(){

            public void performAction(Group group) throws PortalException {
                long groupId;
                long folderId = groupId = group.getGroupId();
                String[] newIds = new String[]{String.valueOf(companyId), String.valueOf(groupId), String.valueOf(folderId)};
                DLFileEntryIndexer.this.reindex(newIds);
            }
        });
        actionableDynamicQuery.performActions();
    }
}

