/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.FileEntryLockException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DLFileEntryServiceImpl
extends DLFileEntryServiceBaseImpl {
    public DLFileEntry addFileEntry(long groupId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_DOCUMENT");
        return this.dlFileEntryLocalService.addFileEntry(this.getUserId(), groupId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, ddmFormValuesMap, file, is, size, serviceContext);
    }

    public DLFileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        boolean locked = LockManagerUtil.isLocked((String)DLFileEntry.class.getName(), (long)fileEntryId);
        if (locked && !this.hasFileEntryLock(fileEntryId) && !this._hasOverrideCheckoutPermission(fileEntryId)) {
            throw new PrincipalException.MustHavePermission(this.getUserId(), DLFileEntry.class.getName(), fileEntryId, new String[]{"OVERRIDE_CHECKOUT"});
        }
        return this.dlFileEntryLocalService.cancelCheckOut(this.getUserId(), fileEntryId);
    }

    public void checkInFileEntry(long fileEntryId, boolean major, String changeLog, ServiceContext serviceContext) throws PortalException {
        boolean isLocked = LockManagerUtil.isLocked((String)DLFileEntry.class.getName(), (long)fileEntryId);
        if (isLocked && !this.hasFileEntryLock(fileEntryId)) {
            throw new FileEntryLockException.MustOwnLock();
        }
        this.dlFileEntryLocalService.checkInFileEntry(this.getUserId(), fileEntryId, major, changeLog, serviceContext);
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        boolean locked = LockManagerUtil.isLocked((String)DLFileEntryConstants.getClassName(), (long)fileEntryId);
        if (locked && !this.hasFileEntryLock(fileEntryId)) {
            throw new FileEntryLockException.MustOwnLock();
        }
        this.dlFileEntryLocalService.checkInFileEntry(this.getUserId(), fileEntryId, lockUuid, serviceContext);
    }

    public DLFileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return this.checkOutFileEntry(fileEntryId, null, DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    public DLFileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        return this.dlFileEntryLocalService.checkOutFileEntry(this.getUserId(), fileEntryId, owner, expirationTime, serviceContext);
    }

    public DLFileEntry copyFileEntry(long groupId, long repositoryId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        DLFolderPermission.check(this.getPermissionChecker(), groupId, destFolderId, "ADD_DOCUMENT");
        return this.dlFileEntryLocalService.copyFileEntry(this.getUserId(), groupId, repositoryId, fileEntryId, destFolderId, serviceContext);
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "DELETE");
        this.dlFileEntryLocalService.deleteFileEntry(this.getUserId(), fileEntryId);
    }

    public void deleteFileEntry(long groupId, long folderId, String title) throws PortalException {
        DLFileEntry dlFileEntry = this.getFileEntry(groupId, folderId, title);
        this.deleteFileEntry(dlFileEntry.getFileEntryId());
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "DELETE");
        this.dlFileEntryLocalService.deleteFileVersion(this.getUserId(), fileEntryId, version);
    }

    public DLFileEntry fetchFileEntryByImageId(long imageId) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryFinder.fetchByAnyImageId(imageId);
        if (dlFileEntry != null) {
            DLFileEntryPermission.check(this.getPermissionChecker(), dlFileEntry, "VIEW");
        }
        return dlFileEntry;
    }

    public InputStream getFileAsStream(long fileEntryId, String version) throws PortalException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileEntryLocalService.getFileAsStream(fileEntryId, version);
    }

    public InputStream getFileAsStream(long fileEntryId, String version, boolean incrementCounter) throws PortalException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileEntryLocalService.getFileAsStream(fileEntryId, version, incrementCounter);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator<DLFileEntry> obc) throws PortalException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        QueryDefinition queryDefinition = new QueryDefinition(status, false, start, end, obc);
        return this.dlFileEntryFinder.filterFindByG_F(groupId, folderIds, queryDefinition);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator<DLFileEntry> obc) throws PortalException {
        return this.getFileEntries(groupId, folderId, 0, start, end, obc);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<DLFileEntry> obc) throws PortalException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        return this.dlFileEntryPersistence.filterFindByG_F_F(groupId, folderId, fileEntryTypeId, start, end, obc);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, String[] mimeTypes, int start, int end, OrderByComparator<DLFileEntry> obc) throws PortalException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        QueryDefinition queryDefinition = new QueryDefinition(8, true, start, end, obc);
        return this.dlFileEntryFinder.filterFindByG_U_F_M(groupId, 0L, folderIds, mimeTypes, queryDefinition);
    }

    public int getFileEntriesCount(long groupId, long folderId) {
        return this.getFileEntriesCount(groupId, folderId, 0);
    }

    public int getFileEntriesCount(long groupId, long folderId, int status) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFileEntryFinder.filterCountByG_F(groupId, folderIds, new QueryDefinition(status));
    }

    public int getFileEntriesCount(long groupId, long folderId, long fileEntryTypeId) {
        return this.dlFileEntryPersistence.filterCountByG_F_F(groupId, folderId, fileEntryTypeId);
    }

    public int getFileEntriesCount(long groupId, long folderId, String[] mimeTypes) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFileEntryFinder.filterCountByG_U_F_M(groupId, 0L, folderIds, mimeTypes, new QueryDefinition(-1));
    }

    public DLFileEntry getFileEntry(long fileEntryId) throws PortalException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileEntryLocalService.getFileEntry(fileEntryId);
    }

    public DLFileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(groupId, folderId, title);
        DLFileEntryPermission.check(this.getPermissionChecker(), dlFileEntry, "VIEW");
        return dlFileEntry;
    }

    public DLFileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByUUID_G(uuid, groupId);
        DLFileEntryPermission.check(this.getPermissionChecker(), dlFileEntry, "VIEW");
        return dlFileEntry;
    }

    public Lock getFileEntryLock(long fileEntryId) {
        try {
            return LockManagerUtil.getLock((String)DLFileEntry.class.getName(), (long)fileEntryId);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public int getFoldersFileEntriesCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.dlFileEntryFinder.filterCountByG_F(groupId, folderIds, queryDefinition);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int filesCount = this.dlFileEntryFinder.filterCountByG_F(groupId, folderIds.subList(start, end), queryDefinition);
        folderIds.subList(start, end).clear();
        return filesCount += this.getFoldersFileEntriesCount(groupId, folderIds, status);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator<DLFileEntry> obc) throws PortalException {
        List folderIds = this.dlFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.filterFindByG_F(groupId, ArrayUtil.toLongArray((Collection)folderIds), start, end, obc);
        }
        return this.dlFileEntryPersistence.filterFindByG_U_F(groupId, userId, ArrayUtil.toLongArray((Collection)folderIds), start, end, obc);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long repositoryId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<DLFileEntry> obc) throws PortalException {
        ArrayList<Long> repositoryIds = new ArrayList<Long>();
        if (repositoryId != 0L) {
            repositoryIds.add(repositoryId);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        if (rootFolderId == 0L) {
            return this.dlFileEntryFinder.filterFindByG_U_R_F_M(groupId, userId, repositoryIds, new ArrayList(), mimeTypes, queryDefinition);
        }
        List folderIds = this.dlFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dlFileEntryFinder.filterFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<DLFileEntry> obc) throws PortalException {
        return this.getGroupFileEntries(groupId, userId, 0L, rootFolderId, mimeTypes, status, start, end, obc);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId) throws PortalException {
        List folderIds = this.dlFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.isEmpty()) {
            return 0;
        }
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.filterCountByG_F(groupId, ArrayUtil.toLongArray((Collection)folderIds));
        }
        return this.dlFileEntryPersistence.filterCountByG_U_F(groupId, userId, ArrayUtil.toLongArray((Collection)folderIds));
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long repositoryId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        ArrayList<Long> repositoryIds = new ArrayList<Long>();
        if (repositoryId != 0L) {
            repositoryIds.add(repositoryId);
        }
        if (rootFolderId == 0L) {
            return this.dlFileEntryFinder.filterCountByG_U_R_F_M(groupId, userId, repositoryIds, new ArrayList(), mimeTypes, new QueryDefinition(status));
        }
        List folderIds = this.dlFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.isEmpty()) {
            return 0;
        }
        return this.dlFileEntryFinder.filterCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, new QueryDefinition(status));
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        return this.getGroupFileEntriesCount(groupId, userId, 0L, rootFolderId, mimeTypes, status);
    }

    public boolean hasFileEntryLock(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        long folderId = dlFileEntry.getFolderId();
        boolean hasLock = LockManagerUtil.hasLock((long)this.getUserId(), (String)DLFileEntry.class.getName(), (long)fileEntryId);
        if (!hasLock && folderId != 0L) {
            hasLock = this.dlFolderLocalService.hasInheritableLock(folderId);
        }
        return hasLock;
    }

    public boolean isFileEntryCheckedOut(long fileEntryId) throws PortalException {
        return this.dlFileEntryLocalService.isFileEntryCheckedOut(fileEntryId);
    }

    public boolean isKeepFileVersionLabel(long fileEntryId, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        DLFileEntryPermission.check(permissionChecker, fileEntryId, "VIEW");
        return this.dlFileEntryLocalService.isKeepFileVersionLabel(fileEntryId, majorVersion, serviceContext);
    }

    @Deprecated
    public boolean isKeepFileVersionLabel(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        DLFileEntryPermission.check(permissionChecker, fileEntryId, "VIEW");
        return this.dlFileEntryLocalService.isKeepFileVersionLabel(fileEntryId, serviceContext);
    }

    public DLFileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        DLFileEntryPermission.check(permissionChecker, fileEntryId, "UPDATE");
        DLFolderPermission.check(permissionChecker, serviceContext.getScopeGroupId(), newFolderId, "ADD_DOCUMENT");
        return this.dlFileEntryLocalService.moveFileEntry(this.getUserId(), fileEntryId, newFolderId, serviceContext);
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return LockManagerUtil.refresh((String)lockUuid, (long)companyId, (long)expirationTime);
    }

    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        this.dlFileEntryLocalService.revertFileEntry(this.getUserId(), fileEntryId, version, serviceContext);
    }

    public Hits search(long groupId, long creatorUserId, int status, int start, int end) throws PortalException {
        return this.dlFileEntryLocalService.search(groupId, this.getUserId(), creatorUserId, status, start, end);
    }

    public Hits search(long groupId, long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        return this.dlFileEntryLocalService.search(groupId, this.getUserId(), creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public DLFileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        boolean hasLock;
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        if (LockManagerUtil.isLocked((String)DLFileEntryConstants.getClassName(), (long)fileEntryId) && !(hasLock = LockManagerUtil.hasLock((long)this.getUserId(), (String)DLFileEntry.class.getName(), (long)fileEntryId))) {
            throw new FileEntryLockException.MustOwnLock();
        }
        return this.dlFileEntryLocalService.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, ddmFormValuesMap, file, is, size, serviceContext);
    }

    public DLFileEntry updateStatus(long userId, long fileVersionId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getFileVersion(fileVersionId);
        DLFileEntryPermission.check(this.getPermissionChecker(), dlFileVersion.getFileEntryId(), "UPDATE");
        return this.dlFileEntryLocalService.updateStatus(userId, fileVersionId, status, serviceContext, workflowContext);
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return this.dlFileEntryLocalService.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        return this.dlFileEntryLocalService.verifyFileEntryLock(fileEntryId, lockUuid);
    }

    private boolean _hasOverrideCheckoutPermission(long fileEntryId) throws PortalException {
        return DLFileEntryPermission.contains(this.getPermissionChecker(), fileEntryId, "OVERRIDE_CHECKOUT");
    }
}

