/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileVersionLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileVersionServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DLFileEntryImpl
extends DLFileEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryImpl.class);
    private UnicodeProperties _extraSettingsProperties;

    public String buildTreePath() throws PortalException {
        if (this.getFolderId() == 0L) {
            return "/";
        }
        DLFolder dlFolder = this.getFolder();
        return dlFolder.buildTreePath();
    }

    public InputStream getContentStream() throws PortalException {
        return this.getContentStream(this.getVersion());
    }

    public InputStream getContentStream(String version) throws PortalException {
        return DLFileEntryServiceUtil.getFileAsStream((long)this.getFileEntryId(), (String)version);
    }

    public long getDataRepositoryId() {
        return DLFolderConstants.getDataRepositoryId((long)this.getGroupId(), (long)this.getFolderId());
    }

    public Map<String, DDMFormValues> getDDMFormValuesMap(long fileVersionId) throws PortalException {
        HashMap<String, DDMFormValues> ddmFormValuesMap = new HashMap<String, DDMFormValues>();
        DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)fileVersionId);
        long fileEntryTypeId = dlFileVersion.getFileEntryTypeId();
        if (fileEntryTypeId <= 0L) {
            return ddmFormValuesMap;
        }
        DLFileEntryType dlFileEntryType = this.getDLFileEntryType();
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.fetchFileEntryMetadata((long)ddmStructure.getStructureId(), (long)fileVersionId);
            if (dlFileEntryMetadata == null) continue;
            DDMFormValues ddmFormValues = StorageEngineManagerUtil.getDDMFormValues((long)dlFileEntryMetadata.getDDMStorageId());
            ddmFormValuesMap.put(ddmStructure.getStructureKey(), ddmFormValues);
        }
        return ddmFormValuesMap;
    }

    public DLFileEntryType getDLFileEntryType() throws PortalException {
        return DLFileEntryTypeLocalServiceUtil.getDLFileEntryType((long)this.getFileEntryTypeId());
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        try {
            DLFileVersion dlFileVersion = this.getFileVersion();
            return dlFileVersion.getExpandoBridge();
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return null;
        }
    }

    @Override
    public String getExtraSettings() {
        if (this._extraSettingsProperties == null) {
            return super.getExtraSettings();
        }
        return this._extraSettingsProperties.toString();
    }

    public UnicodeProperties getExtraSettingsProperties() {
        if (this._extraSettingsProperties == null) {
            this._extraSettingsProperties = new UnicodeProperties(true);
            try {
                this._extraSettingsProperties.load(super.getExtraSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._extraSettingsProperties;
    }

    public List<DLFileShortcut> getFileShortcuts() {
        return DLFileShortcutLocalServiceUtil.getFileShortcuts((long)this.getFileEntryId());
    }

    public DLFileVersion getFileVersion() throws PortalException {
        return this.getFileVersion(this.getVersion());
    }

    public DLFileVersion getFileVersion(String version) throws PortalException {
        return DLFileVersionLocalServiceUtil.getFileVersion((long)this.getFileEntryId(), (String)version);
    }

    public List<DLFileVersion> getFileVersions(int status) {
        return DLFileVersionLocalServiceUtil.getFileVersions((long)this.getFileEntryId(), (int)status);
    }

    public int getFileVersionsCount(int status) {
        return DLFileVersionLocalServiceUtil.getFileVersionsCount((long)this.getFileEntryId(), (int)status);
    }

    public DLFolder getFolder() throws PortalException {
        if (this.getFolderId() <= 0L) {
            return new DLFolderImpl();
        }
        return DLFolderLocalServiceUtil.getFolder((long)this.getFolderId());
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public String getIconCssClass() {
        return DLUtil.getFileIconCssClass((String)this.getExtension());
    }

    public DLFileVersion getLatestFileVersion(boolean trusted) throws PortalException {
        if (trusted) {
            return DLFileVersionLocalServiceUtil.getLatestFileVersion((long)this.getFileEntryId(), (boolean)false);
        }
        return DLFileVersionServiceUtil.getLatestFileVersion((long)this.getFileEntryId());
    }

    public Lock getLock() {
        try {
            return LockManagerUtil.getLock((String)DLFileEntry.class.getName(), (long)this.getFileEntryId());
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return null;
        }
    }

    public String getLuceneProperties() {
        UnicodeProperties extraSettingsProps = this.getExtraSettingsProperties();
        StringBundler sb = new StringBundler(extraSettingsProps.entrySet().size() + 4);
        sb.append(FileUtil.stripExtension((String)this.getTitle()));
        sb.append(" ");
        sb.append(this.getDescription());
        sb.append(" ");
        for (Map.Entry entry : extraSettingsProps.entrySet()) {
            String value = GetterUtil.getString((String)((String)entry.getValue()));
            sb.append(value);
        }
        return sb.toString();
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFileEntryConstants.getClassName());
    }

    @Override
    public int getStatus() {
        try {
            DLFileVersion dlFileVersion = this.getFileVersion();
            return dlFileVersion.getStatus();
        }
        catch (Exception e2) {
            return 0;
        }
    }

    public boolean hasLock() {
        try {
            return DLFileEntryServiceUtil.hasFileEntryLock((long)this.getFileEntryId());
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return false;
        }
    }

    public boolean isCheckedOut() {
        try {
            return DLFileEntryServiceUtil.isFileEntryCheckedOut((long)this.getFileEntryId());
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return false;
        }
    }

    public boolean isInHiddenFolder() {
        try {
            long repositoryId = this.getRepositoryId();
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)repositoryId);
            long dlFolderId = repository.getDlFolderId();
            DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFolderId);
            return dlFolder.isHidden();
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return false;
        }
    }

    @Override
    public boolean isInTrash() {
        return this.getStatus() == 8;
    }

    @Override
    public void setExtraSettings(String extraSettings) {
        this._extraSettingsProperties = null;
        super.setExtraSettings(extraSettings);
    }

    public void setExtraSettingsProperties(UnicodeProperties extraSettingsProperties) {
        this._extraSettingsProperties = extraSettingsProperties;
        super.setExtraSettings(this._extraSettingsProperties.toString());
    }
}

