/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.antivirus;

import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.antivirus.BaseFileAntivirusScanner;
import java.io.File;
import java.io.IOException;

public class ClamAntivirusScannerImpl
extends BaseFileAntivirusScanner {
    public void scan(File file) throws AntivirusScannerException {
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("clamscan", "--stdout", "--no-summary", file.getAbsolutePath());
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue == 1) {
                throw new AntivirusScannerException("Virus detected in " + file.getAbsolutePath(), 2);
            }
            if (exitValue >= 2) {
                throw new AntivirusScannerException(1);
            }
        }
        catch (IOException | InterruptedException e2) {
            throw new AntivirusScannerException(1);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

