/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.persistence.impl;

import com.liferay.blogs.kernel.model.BlogsStatsUser;
import com.liferay.blogs.kernel.service.persistence.BlogsStatsUserFinder;
import com.liferay.blogs.kernel.service.persistence.BlogsStatsUserUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.blogs.model.impl.BlogsStatsUserImpl;
import com.liferay.portlet.blogs.service.persistence.impl.BlogsStatsUserFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class BlogsStatsUserFinderImpl
extends BlogsStatsUserFinderBaseImpl
implements BlogsStatsUserFinder {
    public static final String COUNT_BY_ORGANIZATION_IDS = BlogsStatsUserFinder.class.getName() + ".countByOrganizationIds";
    public static final String FIND_BY_GROUP_IDS = BlogsStatsUserFinder.class.getName() + ".findByGroupIds";
    public static final String FIND_BY_ORGANIZATION_IDS = BlogsStatsUserFinder.class.getName() + ".findByOrganizationIds";

    public int countByOrganizationId(long organizationId) {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.countByOrganizationIds(organizationIds);
    }

    public int countByOrganizationIds(List<Long> organizationIds) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < organizationIds.size(); ++i) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
            }
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsStatsUser> findByGroupIds(long companyId, long groupId, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_GROUP_IDS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("userId", Type.LONG);
            q.addScalar("lastPostDate", Type.TIMESTAMP);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(groupId);
            qPos.add(groupId);
            qPos.add(groupId);
            ArrayList<BlogsStatsUser> statsUsers = new ArrayList<BlogsStatsUser>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Date lastPostDate;
                Object[] array = (Object[])itr.next();
                long userId = (Long)array[0];
                List curStatsUsers = BlogsStatsUserUtil.findByU_L((long)userId, (Date)(lastPostDate = (Date)array[1]));
                if (curStatsUsers.isEmpty()) continue;
                BlogsStatsUser statsUser = (BlogsStatsUser)curStatsUsers.get(0);
                statsUsers.add(statsUser);
            }
            ArrayList<BlogsStatsUser> arrayList = statsUsers;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsStatsUser> findByOrganizationId(long organizationId, int start, int end, OrderByComparator<BlogsStatsUser> obc) {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.findByOrganizationIds(organizationIds, start, end, obc);
    }

    public List<BlogsStatsUser> findByOrganizationIds(List<Long> organizationIds, int start, int end, OrderByComparator<BlogsStatsUser> obc) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, obc);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("BlogsStatsUser", BlogsStatsUserImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < organizationIds.size(); ++i) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        if (organizationIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(organizationIds.size() * 2 - 1);
        for (int i = 0; i < organizationIds.size(); ++i) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i + 1 == organizationIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

