/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence.impl;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.persistence.AssetTagFinder;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.model.impl.AssetTagImpl;
import com.liferay.portlet.asset.service.persistence.impl.AssetTagFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AssetTagFinderImpl
extends AssetTagFinderBaseImpl
implements AssetTagFinder {
    public static final String COUNT_BY_G_N = AssetTagFinder.class.getName() + ".countByG_N";
    public static final String COUNT_BY_G_C_N = AssetTagFinder.class.getName() + ".countByG_C_N";
    public static final String FIND_BY_G_C_N = AssetTagFinder.class.getName() + ".findByG_C_N";
    public static final String FIND_BY_G_N_S_E = AssetTagFinder.class.getName() + ".findByG_N_S_E";

    public int countByG_N(long groupId, String name) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            String lowerCaseName = StringUtil.toLowerCase((String)name);
            qPos.add(lowerCaseName);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_C_N(long groupId, long classNameId, String name) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_C_N);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(classNameId);
            String lowerCaseName = StringUtil.toLowerCase((String)name);
            qPos.add(lowerCaseName);
            qPos.add(lowerCaseName);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AssetTag> findByG_C_N(long groupId, long classNameId, String name, int start, int end, OrderByComparator<AssetTag> obc) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_C_N);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, obc);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AssetTag", AssetTagImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(classNameId);
            String lowerCaseName = StringUtil.toLowerCase((String)name);
            qPos.add(lowerCaseName);
            qPos.add(lowerCaseName);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AssetTag> findByG_N_S_E(long groupId, String name, int startPeriod, int endPeriod, int periodLength) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_S_E);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(startPeriod);
            qPos.add(endPeriod);
            qPos.add(periodLength);
            qPos.add(endPeriod);
            ArrayList<AssetTag> assetTags = new ArrayList<AssetTag>();
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                AssetTagImpl assetTag = new AssetTagImpl();
                assetTag.setTagId(GetterUtil.getLong((Object)array[0]));
                assetTag.setName(GetterUtil.getString((Object)array[1]));
                assetTag.setAssetCount(GetterUtil.getInteger((Object)array[2]));
                assetTags.add(assetTag);
            }
            ArrayList<AssetTag> arrayList = assetTags;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }
}

