/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.util;

import com.liferay.admin.kernel.util.Omniadmin;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;

public class OmniadminImpl
implements Omniadmin {
    private static final Log _log = LogFactoryUtil.getLog(OmniadminImpl.class);

    public boolean isOmniadmin(long userId) {
        try {
            User user = UserLocalServiceUtil.fetchUser((long)userId);
            if (user == null) {
                return false;
            }
            return this.isOmniadmin(user);
        }
        catch (SystemException se) {
            return false;
        }
    }

    public boolean isOmniadmin(User user) {
        long userId = user.getUserId();
        if (userId <= 0L) {
            return false;
        }
        try {
            if (PropsValues.OMNIADMIN_USERS.length > 0) {
                for (int i = 0; i < PropsValues.OMNIADMIN_USERS.length; ++i) {
                    if (PropsValues.OMNIADMIN_USERS[i] != userId) continue;
                    return user.getCompanyId() == PortalInstances.getDefaultCompanyId();
                }
                return false;
            }
            if (user.getCompanyId() != PortalInstances.getDefaultCompanyId()) {
                return false;
            }
            return RoleLocalServiceUtil.hasUserRole((long)userId, (long)user.getCompanyId(), (String)"Administrator", (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
            return false;
        }
    }
}

