/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperTracker;
import com.liferay.portal.kernel.portlet.Route;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portlet.RouterImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FriendlyURLMapperTrackerImpl
implements FriendlyURLMapperTracker {
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLMapperTrackerImpl.class);
    private final Portlet _portlet;
    private final Map<FriendlyURLMapper, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private final ServiceTracker<FriendlyURLMapper, FriendlyURLMapper> _serviceTracker;

    public FriendlyURLMapperTrackerImpl(Portlet portlet) {
        this._portlet = portlet;
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=" + portlet.getPortletId() + ")(objectClass=" + FriendlyURLMapper.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new FriendlyURLMapperServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void close() {
        for (Map.Entry<FriendlyURLMapper, ServiceRegistration<?>> entry : this._serviceRegistrations.entrySet()) {
            ServiceRegistration<?> serviceRegistration = entry.getValue();
            serviceRegistration.unregister();
        }
        this._serviceTracker.close();
    }

    public FriendlyURLMapper getFriendlyURLMapper() {
        return (FriendlyURLMapper)this._serviceTracker.getService();
    }

    public void register(FriendlyURLMapper friendlyURLMapper) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.portlet.name", this._portlet.getPortletId());
        ServiceRegistration serviceRegistration = registry.registerService(FriendlyURLMapper.class, (Object)friendlyURLMapper, properties);
        this._serviceRegistrations.put(friendlyURLMapper, serviceRegistration);
    }

    public void unregister(FriendlyURLMapper friendlyURLMapper) {
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(friendlyURLMapper);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    protected String getContent(ClassLoader classLoader, String fileName) throws Exception {
        String queryString = HttpUtil.getQueryString((String)fileName);
        if (Validator.isNull((String)queryString)) {
            return StringUtil.read((ClassLoader)classLoader, (String)fileName);
        }
        int pos = fileName.indexOf("?");
        String xml = StringUtil.read((ClassLoader)classLoader, (String)fileName.substring(0, pos));
        Map parameterMap = HttpUtil.getParameterMap((String)queryString);
        if (parameterMap == null) {
            return xml;
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 0) continue;
            String value = values[0];
            xml = StringUtil.replace((String)xml, (String)("@" + name + "@"), (String)value);
        }
        return xml;
    }

    private class FriendlyURLMapperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FriendlyURLMapper, FriendlyURLMapper> {
        private FriendlyURLMapperServiceTrackerCustomizer() {
        }

        public FriendlyURLMapper addingService(ServiceReference<FriendlyURLMapper> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            FriendlyURLMapper friendlyURLMapper = (FriendlyURLMapper)registry.getService(serviceReference);
            try {
                if (Validator.isNotNull((String)FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLMapping())) {
                    friendlyURLMapper.setMapping(FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLMapping());
                }
                friendlyURLMapper.setPortletId(FriendlyURLMapperTrackerImpl.this._portlet.getPortletId());
                friendlyURLMapper.setPortletInstanceable(FriendlyURLMapperTrackerImpl.this._portlet.isInstanceable());
                String friendlyURLRoutes = (String)serviceReference.getProperty("com.liferay.portlet.friendly-url-routes");
                if (Validator.isNotNull((String)FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLRoutes())) {
                    friendlyURLRoutes = FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLRoutes();
                }
                String xml = null;
                if (Validator.isNotNull((String)friendlyURLRoutes)) {
                    Class<?> clazz = friendlyURLMapper.getClass();
                    xml = FriendlyURLMapperTrackerImpl.this.getContent(clazz.getClassLoader(), friendlyURLRoutes);
                }
                friendlyURLMapper.setRouter(this.newFriendlyURLRouter(xml));
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                return null;
            }
            return friendlyURLMapper;
        }

        public void modifiedService(ServiceReference<FriendlyURLMapper> serviceReference, FriendlyURLMapper friendlyURLMapper) {
        }

        public void removedService(ServiceReference<FriendlyURLMapper> serviceReference, FriendlyURLMapper friendlyURLMapper) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }

        protected Router newFriendlyURLRouter(String xml) throws Exception {
            if (Validator.isNull((String)xml)) {
                return null;
            }
            Document document = UnsecureSAXReaderUtil.read((String)xml, (boolean)true);
            Element rootElement = document.getRootElement();
            List routeElements = rootElement.elements("route");
            RouterImpl router = new RouterImpl(routeElements.size());
            for (Element routeElement : routeElements) {
                String value;
                String name;
                String pattern = routeElement.elementText("pattern");
                Route route = router.addRoute(pattern);
                for (Element generatedParameterElement : routeElement.elements("generated-parameter")) {
                    name = generatedParameterElement.attributeValue("name");
                    value = generatedParameterElement.getText();
                    route.addGeneratedParameter(name, value);
                }
                for (Element ignoredParameterElement : routeElement.elements("ignored-parameter")) {
                    name = ignoredParameterElement.attributeValue("name");
                    route.addIgnoredParameter(name);
                }
                for (Element implicitParameterElement : routeElement.elements("implicit-parameter")) {
                    name = implicitParameterElement.attributeValue("name");
                    value = implicitParameterElement.getText();
                    route.addImplicitParameter(name, value);
                }
                for (Element overriddenParameterElement : routeElement.elements("overridden-parameter")) {
                    name = overriddenParameterElement.attributeValue("name");
                    value = overriddenParameterElement.getText();
                    route.addOverriddenParameter(name, value);
                }
            }
            return router;
        }
    }
}

