/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;

public class FilterChainImpl
implements FilterChain {
    private final Portlet _portlet;
    private final List<? extends PortletFilter> _portletFilters;
    private int _pos;

    public FilterChainImpl(Portlet portlet, List<? extends PortletFilter> portletFilters) {
        this._portlet = portlet;
        this._portletFilters = portletFilters != null ? portletFilters : Collections.emptyList();
    }

    public void doFilter(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        if (this._portletFilters.size() > this._pos) {
            ActionFilter actionFilter = (ActionFilter)this._portletFilters.get(this._pos++);
            actionFilter.doFilter(actionRequest, actionResponse, (FilterChain)this);
        } else {
            this._portlet.processAction(actionRequest, actionResponse);
        }
    }

    public void doFilter(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        if (this._portletFilters.size() > this._pos) {
            EventFilter eventFilter = (EventFilter)this._portletFilters.get(this._pos++);
            eventFilter.doFilter(eventRequest, eventResponse, (FilterChain)this);
        } else {
            EventPortlet eventPortlet = (EventPortlet)this._portlet;
            eventPortlet.processEvent(eventRequest, eventResponse);
        }
    }

    public void doFilter(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (this._portletFilters.size() > this._pos) {
            RenderFilter renderFilter = (RenderFilter)this._portletFilters.get(this._pos++);
            renderFilter.doFilter(renderRequest, renderResponse, (FilterChain)this);
        } else {
            this._portlet.render(renderRequest, renderResponse);
        }
    }

    public void doFilter(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (this._portletFilters.size() > this._pos) {
            ResourceFilter resourceFilter = (ResourceFilter)this._portletFilters.get(this._pos++);
            resourceFilter.doFilter(resourceRequest, resourceResponse, (FilterChain)this);
        } else {
            ResourceServingPortlet resourceServingPortlet = (ResourceServingPortlet)this._portlet;
            resourceServingPortlet.serveResource(resourceRequest, resourceResponse);
        }
    }
}

