/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.xmlrpc.Fault;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.XmlRpcException;
import com.liferay.portal.kernel.xmlrpc.XmlRpcUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.xmlrpc.XmlRpcMethodUtil;
import com.liferay.portal.xmlrpc.XmlRpcParser;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XmlRpcServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(XmlRpcServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PortalUtil.sendError((int)404, (Exception)new IllegalArgumentException("The GET method is not supported"), (HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        Fault xmlRpcResponse = null;
        try {
            long companyId = PortalInstances.getCompanyId(request);
            String token = this.getToken(request);
            ServletInputStream is = request.getInputStream();
            String xml = StringUtil.read((InputStream)is);
            Tuple methodTuple = XmlRpcParser.parseMethod(xml);
            String methodName = (String)methodTuple.getObject(0);
            Object[] args = (Object[])methodTuple.getObject(1);
            xmlRpcResponse = this.invokeMethod(companyId, token, methodName, args);
        }
        catch (IOException ioe) {
            xmlRpcResponse = XmlRpcUtil.createFault((int)-32700, (String)"XML is not well formed");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ioe, (Throwable)ioe);
            }
        }
        catch (XmlRpcException xre) {
            _log.error((Object)xre, (Throwable)xre);
        }
        if (xmlRpcResponse == null) {
            xmlRpcResponse = XmlRpcUtil.createFault((int)-32400, (String)"Unknown error occurred");
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/xml");
        response.setStatus(200);
        try {
            ServletResponseUtil.write((HttpServletResponse)response, (String)xmlRpcResponse.toXml());
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            response.setStatus(412);
        }
    }

    protected String getToken(HttpServletRequest request) {
        String token = request.getPathInfo();
        return HttpUtil.fixPath((String)token);
    }

    protected Response invokeMethod(long companyId, String token, String methodName, Object[] arguments) throws XmlRpcException {
        Method method = XmlRpcMethodUtil.getMethod(token, methodName);
        if (method == null) {
            return XmlRpcUtil.createFault((int)-32601, (String)"Requested method not found");
        }
        if (!method.setArguments(arguments)) {
            return XmlRpcUtil.createFault((int)-32602, (String)"Method arguments are invalid");
        }
        return method.execute(companyId);
    }
}

