/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.webdav.methods.MethodFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webdav.CompanyWebDAVStorageImpl;
import com.liferay.portal.webdav.GroupWebDAVStorageImpl;
import com.liferay.portal.webdav.WebDAVRequestImpl;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebDAVServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(WebDAVServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) {
        int status = 412;
        String userAgent = request.getHeader("User-Agent");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("User agent " + userAgent));
        }
        try {
            if (this.isIgnoredResource(request)) {
                status = 404;
                return;
            }
            WebDAVStorage storage = this.getStorage(request);
            if (storage == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Invalid WebDAV path " + request.getPathInfo()));
                }
                return;
            }
            if (storage.getRootPath() == null) {
                storage.setRootPath(this.getRootPath(request));
            }
            PermissionChecker permissionChecker = null;
            String remoteUser = request.getRemoteUser();
            if (remoteUser != null) {
                PrincipalThreadLocal.setName((String)remoteUser);
                long userId = GetterUtil.getLong((String)remoteUser);
                User user = UserLocalServiceUtil.getUserById((long)userId);
                permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            }
            MethodFactory methodFactory = storage.getMethodFactory();
            Method method = methodFactory.create(request);
            try {
                WebDAVRequestImpl webDAVRequest = new WebDAVRequestImpl(storage, request, response, userAgent, permissionChecker);
                status = method.process((WebDAVRequest)webDAVRequest);
            }
            catch (WebDAVException wdave) {
                boolean logError = false;
                for (Throwable cause = wdave; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof PrincipalException)) continue;
                    logError = true;
                }
                if (logError) {
                    _log.error((Object)wdave, (Throwable)wdave);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)wdave, (Throwable)wdave);
                }
                status = 412;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        finally {
            response.setStatus(status);
            if (_log.isInfoEnabled()) {
                String xLitmus = GetterUtil.getString((String)request.getHeader("X-Litmus"));
                if (Validator.isNotNull((String)xLitmus)) {
                    xLitmus = xLitmus + " ";
                }
                _log.info((Object)(xLitmus + request.getMethod() + " " + request.getRequestURI() + " " + status));
            }
        }
    }

    protected String getRootPath(HttpServletRequest request) {
        String contextPath = HttpUtil.fixPath((String)PortalUtil.getPathContext((HttpServletRequest)request), (boolean)false, (boolean)true);
        String servletPath = HttpUtil.fixPath((String)request.getServletPath(), (boolean)false, (boolean)true);
        return contextPath.concat(servletPath);
    }

    protected WebDAVStorage getStorage(HttpServletRequest request) {
        String pathInfo = WebDAVUtil.stripManualCheckInRequiredPath((String)request.getPathInfo());
        pathInfo = WebDAVUtil.stripOfficeExtension((String)pathInfo);
        String[] pathArray = WebDAVUtil.getPathArray((String)pathInfo, (boolean)true);
        WebDAVStorage storage = null;
        if (pathArray.length == 0) {
            storage = (WebDAVStorage)InstancePool.get((String)CompanyWebDAVStorageImpl.class.getName());
        } else if (pathArray.length == 1) {
            storage = (WebDAVStorage)InstancePool.get((String)GroupWebDAVStorageImpl.class.getName());
        } else if (pathArray.length >= 2) {
            storage = WebDAVUtil.getStorage((String)pathArray[1]);
        }
        return storage;
    }

    protected boolean isIgnoredResource(HttpServletRequest request) {
        Object[] pathArray = WebDAVUtil.getPathArray((String)request.getPathInfo(), (boolean)true);
        if (ArrayUtil.isEmpty((Object[])pathArray)) {
            return false;
        }
        for (String ignore : PropsValues.WEBDAV_IGNORE) {
            String[] ignoreArray = ignore.split("/");
            if (ignoreArray.length > pathArray.length) continue;
            boolean match = true;
            for (int i = 1; i <= ignoreArray.length; ++i) {
                if (((String)pathArray[pathArray.length - i]).equals(ignoreArray[ignoreArray.length - i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping over " + request.getMethod() + " " + request.getPathInfo()));
            }
            return true;
        }
        return false;
    }
}

