/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class VerifyOracle
extends VerifyProcess {
    private static final int[] _ORIGINAL_DATA_LENGTH_VALUES = new int[]{75, 100, 150, 200, 255, 500, 1000, 1024, 2000, 4000};
    private static final Log _log = LogFactoryUtil.getLog(VerifyOracle.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void alterVarchar2Columns() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select table_name, column_name, data_length from user_tab_columns where data_type = 'VARCHAR2' and char_used = 'B'");
             ResultSet rs = ps.executeQuery();){
            int buildNumber = this.getBuildNumber();
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (!this.isPortalTableName(tableName)) continue;
                String columnName = rs.getString(2);
                int dataLength = rs.getInt(3);
                if ((this.isBetweenBuildNumbers(buildNumber, 5209, 6000) || this.isBetweenBuildNumbers(buildNumber, 6005, 6120)) && !ArrayUtil.contains((int[])_ORIGINAL_DATA_LENGTH_VALUES, (int)dataLength)) {
                    dataLength /= 4;
                }
                try {
                    this.runSQL("alter table " + tableName + " modify " + columnName + " varchar2(" + dataLength + " char)");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() != 1441) throw sqle;
                    if (!_log.isWarnEnabled()) continue;
                    StringBundler sb = new StringBundler(6);
                    sb.append("Unable to alter length of column ");
                    sb.append(columnName);
                    sb.append(" for table ");
                    sb.append(tableName);
                    sb.append(" because it contains values that are ");
                    sb.append("larger than the new column length");
                    _log.warn((Object)sb.toString());
                    continue;
                    return;
                }
            }
        }
    }

    @Override
    protected void doVerify() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.ORACLE) {
            return;
        }
        this.alterVarchar2Columns();
    }

    protected boolean isBetweenBuildNumbers(int buildNumber, int startBuildNumber, int endBuildNumber) {
        return buildNumber >= startBuildNumber && buildNumber < endBuildNumber;
    }
}

