/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReaderMetKeys;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MimeTypesImpl
implements com.liferay.portal.kernel.util.MimeTypes,
MimeTypesReaderMetKeys {
    private static final Log _log = LogFactoryUtil.getLog(MimeTypesImpl.class);
    private final Detector _detector;
    private final Map<String, Set<String>> _extensionsMap = new HashMap<String, Set<String>>();
    private final Set<String> _webImageMimeTypes;

    public MimeTypesImpl() {
        this._detector = new DefaultDetector(MimeTypes.getDefaultMimeTypes());
        this._webImageMimeTypes = SetUtil.fromArray((Object[])PropsValues.MIME_TYPES_WEB_IMAGES);
    }

    public void afterPropertiesSet() {
        URL url = MimeTypes.class.getResource("tika-mimetypes.xml");
        try {
            this.read(url.openStream());
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to populate extensions map", (Throwable)e2);
        }
    }

    public String getContentType(File file) {
        return this.getContentType(file, file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType(File file, String fileName) {
        String string;
        if (file == null || !file.exists()) {
            return this.getContentType(fileName);
        }
        TikaInputStream is = null;
        try {
            is = TikaInputStream.get((File)file);
            string = this.getContentType((InputStream)is, fileName);
        }
        catch (FileNotFoundException fnfe) {
            String string2;
            try {
                string2 = this.getContentType(fileName);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{is});
            return string2;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{is});
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType(InputStream inputStream, String fileName) {
        TikaInputStream tikaInputStream;
        String contentType;
        block8: {
            if (inputStream == null) {
                return this.getContentType(fileName);
            }
            contentType = null;
            tikaInputStream = null;
            try {
                tikaInputStream = TikaInputStream.get((InputStream)new CloseShieldInputStream(inputStream));
                Metadata metadata = new Metadata();
                metadata.set("resourceName", fileName);
                MediaType mediaType = this._detector.detect((InputStream)tikaInputStream, metadata);
                contentType = mediaType.toString();
                if (contentType.contains("tika")) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Retrieved invalid content type " + contentType));
                    }
                    contentType = this.getContentType(fileName);
                }
                if (!contentType.contains("tika")) break block8;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Retrieved invalid content type " + contentType));
                }
                contentType = "application/octet-stream";
            }
            catch (Exception e2) {
                try {
                    _log.error((Object)e2, (Throwable)e2);
                    contentType = "application/octet-stream";
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{tikaInputStream});
                    throw throwable;
                }
                StreamUtil.cleanUp((Closeable[])new Closeable[]{tikaInputStream});
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{tikaInputStream});
        return contentType;
    }

    public String getContentType(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return "application/octet-stream";
        }
        try {
            Metadata metadata = new Metadata();
            metadata.set("resourceName", fileName);
            MediaType mediaType = this._detector.detect(null, metadata);
            String contentType = mediaType.toString();
            if (!contentType.contains("tika")) {
                return contentType;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Retrieved invalid content type " + contentType));
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return "application/octet-stream";
    }

    public String getExtensionContentType(String extension) {
        if (Validator.isNull((String)extension)) {
            return "application/octet-stream";
        }
        return this.getContentType("A.".concat(extension));
    }

    public Set<String> getExtensions(String contentType) {
        Set<String> extensions = this._extensionsMap.get(contentType);
        if (extensions == null) {
            extensions = Collections.emptySet();
        }
        return extensions;
    }

    public boolean isWebImage(String mimeType) {
        return this._webImageMimeTypes.contains(mimeType);
    }

    protected void read(InputStream stream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(stream));
        Element element = document.getDocumentElement();
        if (element == null || !"mime-info".equals(element.getTagName())) {
            throw new SystemException("Invalid configuration file");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"mime-type".equals((childElement = (Element)node).getTagName())) continue;
            this.readMimeType(childElement);
        }
    }

    protected void readMimeType(Element element) {
        HashSet<String> mimeTypes = new HashSet<String>();
        HashSet<String> extensions = new HashSet<String>();
        String name = element.getAttribute("type");
        mimeTypes.add(name);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String extension;
            String pattern;
            boolean isRegex;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if ("alias".equals(childElement.getTagName())) {
                String alias = childElement.getAttribute("type");
                mimeTypes.add(alias);
                continue;
            }
            if (!"glob".equals(childElement.getTagName()) || (isRegex = GetterUtil.getBoolean((String)childElement.getAttribute("isregex"))) || !(pattern = childElement.getAttribute("pattern")).startsWith("*") || (extension = pattern.substring(1)).contains("*") || extension.contains("?") || extension.contains("[")) continue;
            extensions.add(extension);
        }
        for (String mimeType : mimeTypes) {
            this._extensionsMap.put(mimeType, extensions);
        }
    }
}

