/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;

public class LayoutURLUtil {
    public static String getLayoutURL(Layout layout, ServiceContext serviceContext) {
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            return PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        catch (Exception e2) {
            return "";
        }
    }

    public static String getLayoutURL(long groupId, String portletId, ServiceContext serviceContext) throws PortalException {
        long controlPanelPlid;
        long plid = serviceContext.getPlid();
        if (plid == (controlPanelPlid = PortalUtil.getControlPanelPlid((long)serviceContext.getCompanyId()))) {
            plid = PortalUtil.getPlidFromPortletId((long)groupId, (String)portletId);
        }
        String layoutURL = "";
        if (plid != 0L) {
            Layout layout = LayoutUtil.findByPrimaryKey((long)plid);
            layoutURL = LayoutURLUtil.getLayoutURL(layout, serviceContext);
        }
        return layoutURL;
    }
}

