/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeCommunityProperties
extends UpgradeProcess {
    private static final String[] _NEW_PORTAL_PREFERENCES = new String[]{"company.security.site.logo", "sites.email.from.address", "sites.email.from.name", "sites.email.membership.reply.body", "sites.email.membership.reply.subject", "sites.email.membership.request.body", "sites.email.membership.request.subject"};
    private static final String[] _NEW_PORTLET_PREFERENCES = new String[]{"site-role", "[$SITE_NAME$]"};
    private static final String[] _OLD_PORTAL_PREFERENCES = new String[]{"company.security.community.logo", "communities.email.from.address", "communities.email.from.name", "communities.email.membership.reply.body", "communities.email.membership.reply.subject", "communities.email.membership.request.body", "communities.email.membership.request.subject"};
    private static final String[] _OLD_PORTLET_PREFERENCES = new String[]{"community-role", "[$COMMUNITY_NAME$]"};

    protected void doUpgrade() throws Exception {
        this.upgradePortletPreferences();
        this.upgradePortalPreferences();
    }

    protected void updatePreferences(String tableName, String primaryKeyColumnName, String oldValue, String newValue) throws Exception {
        StringBundler sb = new StringBundler(9);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set preferences = replace(preferences, '");
        sb.append(oldValue);
        sb.append("', '");
        sb.append(newValue);
        sb.append("') where preferences like '%");
        sb.append(oldValue);
        sb.append("%'");
        try {
            this.runSQL(sb.toString());
        }
        catch (Exception e2) {
            sb = new StringBundler(7);
            sb.append("select ");
            sb.append(primaryKeyColumnName);
            sb.append(", preferences from ");
            sb.append(tableName);
            sb.append(" where preferences like '%");
            sb.append(oldValue);
            sb.append("%'");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long primaryKey = rs.getLong(primaryKeyColumnName);
                    String preferences = rs.getString("preferences");
                    this.updatePreferences(tableName, primaryKeyColumnName, oldValue, newValue, primaryKey, preferences);
                }
            }
        }
    }

    protected void updatePreferences(String tableName, String primaryKeyColumnName, String oldValue, String newValue, long primaryKey, String preferences) throws Exception {
        preferences = StringUtil.replace((String)preferences, (String)oldValue, (String)newValue);
        StringBundler sb = new StringBundler(5);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set preferences = ? where ");
        sb.append(primaryKeyColumnName);
        sb.append(" = ?");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setString(1, preferences);
            ps.setLong(2, primaryKey);
            ps.executeUpdate();
        }
    }

    protected void upgradePortalPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            for (int i = 0; i < _OLD_PORTAL_PREFERENCES.length; ++i) {
                this.updatePreferences("PortalPreferences", "portalPreferencesId", _OLD_PORTAL_PREFERENCES[i], _NEW_PORTAL_PREFERENCES[i]);
            }
        }
    }

    protected void upgradePortletPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            for (int i = 0; i < _OLD_PORTLET_PREFERENCES.length; ++i) {
                this.updatePreferences("PortletPreferences", "portletPreferencesId", _OLD_PORTLET_PREFERENCES[i], _NEW_PORTLET_PREFERENCES[i]);
            }
        }
    }
}

