/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.PortletInstance;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class UpgradePortletId
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradePortletId.class);

    protected void doUpgrade() throws Exception {
        this.upgradeInstanceablePortletIds();
        this.upgradeUninstanceablePortletIds();
    }

    protected String getNewTypeSettings(String typeSettings, String oldRootPortletId, String newRootPortletId, boolean exactMatch) {
        throw new UnsupportedOperationException("This class is deprecated and replaced by com.liferay.portal.kernel.upgrade.BaseUpgradePortletId");
    }

    protected String getNewTypeSettings(String typeSettings, String oldRootPortletId, String newRootPortletId, List<String> columnIds, boolean exactMatch) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        for (String columnId : columnIds) {
            if (!typeSettingsProperties.containsKey((Object)columnId)) continue;
            Object[] portletIds = StringUtil.split((String)typeSettingsProperties.getProperty(columnId));
            for (int j = 0; j < portletIds.length; ++j) {
                String portletId = portletIds[j];
                if (exactMatch) {
                    if (!portletId.equals(oldRootPortletId)) continue;
                    portletIds[j] = newRootPortletId;
                    continue;
                }
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                if (!rootPortletId.equals(oldRootPortletId)) continue;
                long userId = PortletConstants.getUserId((String)portletId);
                String instanceId = PortletConstants.getInstanceId((String)portletId);
                portletIds[j] = PortletConstants.assemblePortletId((String)newRootPortletId, (long)userId, (String)instanceId);
            }
            typeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds).concat(","));
        }
        return typeSettingsProperties.toString();
    }

    protected String[][] getRenamePortletIdsArray() {
        return new String[][]{{"109", "1_WAR_webformportlet"}, {"google_adsense_portlet_WAR_googleadsenseportlet", "1_WAR_googleadsenseportlet"}, {"google_gadget_portlet_WAR_googlegadgetportlet", "1_WAR_googlegadgetportlet"}, {"google_maps_portlet_WAR_googlemapsportlet", "1_WAR_googlemapsportlet"}};
    }

    protected String getTypeSettingsCriteria(String portletId) {
        StringBundler sb = new StringBundler(21);
        sb.append("typeSettings like '%=");
        sb.append(portletId);
        sb.append(",%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("\n%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append(",%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("\n%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("_INSTANCE_%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("_INSTANCE_%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("_USER_%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("_USER_%'");
        return sb.toString();
    }

    protected String[] getUninstanceablePortletIds() {
        return new String[0];
    }

    protected void updateInstanceablePortletPreferences(String oldRootPortletId, String newRootPortletId) throws Exception {
        StringBundler sb = new StringBundler(8);
        sb.append("select portletPreferencesId, portletId from ");
        sb.append("PortletPreferences where portletId = '");
        sb.append(oldRootPortletId);
        sb.append("' OR portletId like '");
        sb.append(oldRootPortletId);
        sb.append("_INSTANCE_%' OR portletId like '");
        sb.append(oldRootPortletId);
        sb.append("_USER_%_INSTANCE_%'");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortletPreferences set portletId = ? where portletPreferencesId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                String portletId = rs.getString("portletId");
                String newPortletId = StringUtil.replace((String)portletId, (String)oldRootPortletId, (String)newRootPortletId);
                ps2.setString(1, newPortletId);
                ps2.setLong(2, portletPreferencesId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void updateLayout(long plid, String typeSettings) throws Exception {
        block14: {
            try (PreparedStatement ps = this.connection.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);){
                ps.setString(1, typeSettings);
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateLayout(long plid, String oldPortletId, String newPortletId) throws Exception {
        block27: {
            try (PreparedStatement ps = this.connection.prepareStatement("select typeSettings from Layout where plid = " + plid);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String typeSettings = rs.getString("typeSettings");
                    String newTypeSettings = StringUtil.replace((String)typeSettings, (String)oldPortletId, (String)newPortletId);
                    this.updateLayout(plid, newTypeSettings);
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block27;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
    }

    protected void updateLayoutRevision(long layoutRevisionId, String typeSettings) throws Exception {
        block14: {
            String sql = "update LayoutRevision set typeSettings = ? where layoutRevisionId = " + layoutRevisionId;
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.setString(1, typeSettings);
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateLayoutRevisions(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        String sql = "select layoutRevisionId, typeSettings from LayoutRevision where " + this.getTypeSettingsCriteria(oldRootPortletId);
        try (PreparedStatement ps = this.connection.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long layoutRevisionId = rs.getLong("layoutRevisionId");
                String typeSettings = rs.getString("typeSettings");
                List<String> layoutColumnIds = this._getLayoutColumnIds();
                layoutColumnIds.addAll(this._getNestedPortletColumnIds(typeSettings));
                String newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, layoutColumnIds, exactMatch);
                this.updateLayoutRevision(layoutRevisionId, newTypeSettings);
            }
        }
    }

    protected void updateLayouts(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        String sql = "select plid, typeSettings from Layout where " + this.getTypeSettingsCriteria(oldRootPortletId);
        try (PreparedStatement ps = this.connection.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long plid = rs.getLong("plid");
                String typeSettings = rs.getString("typeSettings");
                List<String> layoutColumnIds = this._getLayoutColumnIds();
                layoutColumnIds.addAll(this._getNestedPortletColumnIds(typeSettings));
                String newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, layoutColumnIds, exactMatch);
                this.updateLayout(plid, newTypeSettings);
            }
        }
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        block2: {
            try {
                this.updatePortletId(oldRootPortletId, newRootPortletId);
                this.updateResourceAction(oldRootPortletId, newRootPortletId);
                this.updateResourcePermission(oldRootPortletId, newRootPortletId, true);
                this.updateUserNotificationDelivery(oldRootPortletId, newRootPortletId);
                this.updateUserNotificationEvent(oldRootPortletId, newRootPortletId);
                this.updateInstanceablePortletPreferences(oldRootPortletId, newRootPortletId);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
    }

    protected void updatePortletId(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL("update Portlet set portletId = '" + newRootPortletId + "' where portletId = '" + oldRootPortletId + "'");
    }

    protected void updateResourceAction(String oldName, String newName) throws Exception {
        this.runSQL("update ResourceAction set name = '" + newName + "' where name = '" + oldName + "'");
    }

    protected void updateResourcePermission(String oldRootPortletId, String newRootPortletId, boolean updateName) throws Exception {
        block43: {
            try (PreparedStatement ps1 = this.connection.prepareStatement("select resourcePermissionId, name, scope, primKey from ResourcePermission where name = '" + oldRootPortletId + "'");
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update ResourcePermission set name = ?, primKey = ? where resourcePermissionId = ?");
                 ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long resourcePermissionId = rs.getLong("resourcePermissionId");
                    String name = rs.getString("name");
                    int scope = rs.getInt("scope");
                    String primKey = rs.getString("primKey");
                    String newName = name;
                    if (updateName) {
                        newName = newRootPortletId;
                    }
                    if (scope == 4) {
                        int pos = primKey.indexOf("_LAYOUT_");
                        if (pos != -1) {
                            long plid = GetterUtil.getLong((String)primKey.substring(0, pos));
                            String portletId = primKey.substring(pos + "_LAYOUT_".length());
                            String instanceId = PortletConstants.getInstanceId((String)portletId);
                            long userId = PortletConstants.getUserId((String)portletId);
                            String newPortletId = PortletConstants.assemblePortletId((String)newRootPortletId, (long)userId, (String)instanceId);
                            primKey = PortletPermissionUtil.getPrimaryKey((long)plid, (String)newPortletId);
                        }
                        if (name.equals(primKey)) {
                            primKey = newName;
                        }
                    }
                    ps2.setString(1, newName);
                    ps2.setString(2, primKey);
                    ps2.setLong(3, resourcePermissionId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block43;
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateUserNotificationDelivery(String oldPortletId, String newPortletId) throws Exception {
        this.runSQL("update UserNotificationDelivery set portletId = '" + newPortletId + "' where portletId = '" + oldPortletId + "'");
    }

    protected void updateUserNotificationEvent(String oldPortletId, String newPortletId) throws Exception {
        this.runSQL("update UserNotificationEvent set type_ = '" + newPortletId + "' where type_ = '" + oldPortletId + "'");
    }

    protected void upgradeInstanceablePortletIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[][] renamePortletIdsArray;
            for (String[] renamePortletIds : renamePortletIdsArray = this.getRenamePortletIdsArray()) {
                String oldRootPortletId = renamePortletIds[0];
                String newRootPortletId = renamePortletIds[1];
                this.updatePortlet(oldRootPortletId, newRootPortletId);
                this.updateLayoutRevisions(oldRootPortletId, newRootPortletId, false);
                this.updateLayouts(oldRootPortletId, newRootPortletId, false);
            }
        }
    }

    protected void upgradeUninstanceablePortletIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[] uninstanceablePortletIds;
            for (String portletId : uninstanceablePortletIds = this.getUninstanceablePortletIds()) {
                PortletInstance portletInstance = PortletInstance.fromPortletInstanceKey((String)portletId);
                if (portletInstance.hasInstanceId()) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Portlet " + portletId + " is already instanceable"));
                    continue;
                }
                PortletInstance newPortletInstance = new PortletInstance(portletId);
                String newPortletInstanceKey = newPortletInstance.getPortletInstanceKey();
                this.updateInstanceablePortletPreferences(portletId, newPortletInstanceKey);
                this.updateResourcePermission(portletId, newPortletInstanceKey, false);
                this.updateLayoutRevisions(portletId, newPortletInstanceKey, true);
                this.updateLayouts(portletId, newPortletInstanceKey, true);
            }
        }
    }

    private List<String> _getLayoutColumnIds() {
        ArrayList<String> columnIds = new ArrayList<String>();
        for (int i = 1; i <= 10; ++i) {
            columnIds.add("column-" + i);
        }
        return columnIds;
    }

    private List<String> _getNestedPortletColumnIds(String typeSettings) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        if (!typeSettingsProperties.containsKey((Object)"nested-column-ids")) {
            return Collections.emptyList();
        }
        Object[] nestedPortletColumnIds = StringUtil.split((String)typeSettingsProperties.getProperty("nested-column-ids"));
        return ListUtil.fromArray((Object[])nestedPortletColumnIds);
    }
}

