/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.util.Table;
import java.sql.Connection;

public abstract class BaseUpgradeTableImpl
extends Table {
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradeTableImpl.class);
    private boolean _allowUniqueIndexes;
    private boolean _calledUpdateTable;
    private boolean _deleteTempFile;
    private String[] _indexesSQL = new String[0];

    public BaseUpgradeTableImpl(String tableName) {
        super(tableName);
    }

    public String[] getIndexesSQL() throws Exception {
        return this._indexesSQL;
    }

    public boolean isAllowUniqueIndexes() throws Exception {
        return this._allowUniqueIndexes;
    }

    public boolean isDeleteTempFile() {
        return this._deleteTempFile;
    }

    public void setAllowUniqueIndexes(boolean allowUniqueIndexes) throws Exception {
        this._allowUniqueIndexes = allowUniqueIndexes;
    }

    @Override
    public void setCreateSQL(String createSQL) throws Exception {
        if (this._calledUpdateTable) {
            throw new UpgradeException("setCreateSQL is called after updateTable");
        }
        super.setCreateSQL(createSQL);
    }

    public void setDeleteTempFile(boolean deleteTempFile) {
        this._deleteTempFile = deleteTempFile;
    }

    public void setIndexesSQL(String[] indexesSQL) throws Exception {
        this._indexesSQL = indexesSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable() throws Exception {
        Connection connection = DataAccess.getUpgradeOptimizedConnection();
        try {
            this.updateTable(connection, connection, true);
        }
        finally {
            DataAccess.cleanUp((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTable(Connection sourceConnection, Connection targetConnection, boolean deleteSource) throws Exception {
        this._calledUpdateTable = true;
        this.generateTempFile(sourceConnection);
        String tempFileName = this.getTempFileName();
        try {
            String createSQL;
            DB db = DBManagerUtil.getDB();
            if (Validator.isNotNull((String)tempFileName) && deleteSource) {
                String deleteSQL = this.getDeleteSQL();
                db.runSQL(sourceConnection, deleteSQL);
            }
            if (Validator.isNotNull((String)(createSQL = this.getCreateSQL()))) {
                if (deleteSource) {
                    db.runSQL(sourceConnection, "drop table " + this.getTableName());
                }
                db.runSQL(targetConnection, createSQL);
            }
            this.populateTable(targetConnection);
            String[] indexesSQL = this.getIndexesSQL();
            boolean dropIndexes = false;
            for (String indexSQL : indexesSQL) {
                if (!this.isAllowUniqueIndexes() && indexSQL.contains("create unique index")) {
                    indexSQL = StringUtil.replace((String)indexSQL, (String)"create unique index ", (String)"create index ");
                    dropIndexes = true;
                }
                try {
                    db.runSQLTemplateString(targetConnection, indexSQL, false, false);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)(e2.getMessage() + ": " + indexSQL));
                }
            }
            if (dropIndexes) {
                StartupHelperUtil.setDropIndexes(true);
            }
        }
        finally {
            if (Validator.isNotNull((String)tempFileName) && this._deleteTempFile) {
                FileUtil.delete((String)tempFileName);
            }
        }
    }
}

