/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManager;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManagerUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;

public class TransactionsUtil {
    private static final Log _log = LogFactoryUtil.getLog(TransactionsUtil.class);

    public static void disableTransactions() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Disable transactions");
        }
        PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED = false;
        try {
            Field field = ReflectionUtil.getDeclaredField(ServiceBeanAopCacheManager.class, (String)"_annotations");
            field.set(null, new HashMap<MethodInvocation, Annotation[]>(){
                private final Annotation[] _annotations = new Annotation[]{new Skip(){

                    public Class<? extends Annotation> annotationType() {
                        return Skip.class;
                    }
                }};

                @Override
                public Annotation[] get(Object key) {
                    return this._annotations;
                }
            });
        }
        catch (Exception e2) {
            throw new RuntimeException("Unexpected error disabling transactions", e2);
        }
    }

    public static void enableTransactions() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Enable transactions");
        }
        PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED = GetterUtil.getBoolean((String)PropsUtil.get("spring.hibernate.session.delegated"));
        try {
            Field field = ReflectionUtil.getDeclaredField(ServiceBeanAopCacheManager.class, (String)"_annotations");
            field.set(null, new ConcurrentHashMap());
            ServiceBeanAopCacheManagerUtil.reset();
        }
        catch (Exception e2) {
            throw new RuntimeException("Unexpected error disabling transactions", e2);
        }
    }
}

