/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.templateparser;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Transformer {
    protected final Map<String, String> errorTemplateIds = new HashMap<String, String>();
    protected final Set<TransformerListener> transformerListeners = new HashSet<TransformerListener>();
    private static final Log _log = LogFactoryUtil.getLog(Transformer.class);
    private final boolean _restricted;

    public Transformer(String errorTemplatePropertyKey, boolean restricted) {
        this._restricted = restricted;
        this.setErrorTemplateIds(errorTemplatePropertyKey);
    }

    public Transformer(String transformerListenerPropertyKey, String errorTemplatePropertyKey, boolean restricted) {
        this(errorTemplatePropertyKey, restricted);
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        this.setTransformerListeners(transformerListenerPropertyKey, classLoader);
    }

    public String transform(ThemeDisplay themeDisplay, Map<String, Object> contextObjects, String script, String langType, UnsyncStringWriter unsyncStringWriter) throws Exception {
        if (Validator.isNull((String)langType)) {
            return null;
        }
        long companyId = 0L;
        long companyGroupId = 0L;
        long scopeGroupId = 0L;
        long siteGroupId = 0L;
        if (themeDisplay != null) {
            companyId = themeDisplay.getCompanyId();
            companyGroupId = themeDisplay.getCompanyGroupId();
            scopeGroupId = themeDisplay.getScopeGroupId();
            siteGroupId = themeDisplay.getSiteGroupId();
        }
        String templateId = String.valueOf(contextObjects.get("template_id"));
        templateId = this.getTemplateId(templateId, companyId, companyGroupId, scopeGroupId);
        Template template = this.getTemplate(templateId, script, langType);
        try {
            this.prepareTemplate(themeDisplay, template);
            template.putAll(contextObjects);
            long classNameId = GetterUtil.getLong((Object)contextObjects.get("class_name_id"));
            template.put((Object)"company", (Object)this.getCompany(themeDisplay, companyId));
            template.put((Object)"companyId", (Object)companyId);
            template.put((Object)"device", (Object)this.getDevice(themeDisplay));
            String templatesPath = this.getTemplatesPath(companyId, scopeGroupId, classNameId);
            template.put((Object)"permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
            template.put((Object)"randomNamespace", (Object)(StringUtil.randomId() + "_"));
            template.put((Object)"scopeGroupId", (Object)scopeGroupId);
            template.put((Object)"siteGroupId", (Object)siteGroupId);
            template.put((Object)"templatesPath", (Object)templatesPath);
            template.put((Object)"groupId", (Object)scopeGroupId);
            template.put((Object)"journalTemplatesPath", (Object)templatesPath);
            this.mergeTemplate(template, unsyncStringWriter, false);
        }
        catch (Exception e2) {
            throw new TransformException("Unhandled exception", (Throwable)e2);
        }
        return unsyncStringWriter.toString();
    }

    protected Company getCompany(ThemeDisplay themeDisplay, long companyId) throws Exception {
        if (themeDisplay != null) {
            return themeDisplay.getCompany();
        }
        return CompanyLocalServiceUtil.getCompany((long)companyId);
    }

    protected Device getDevice(ThemeDisplay themeDisplay) {
        if (themeDisplay != null) {
            return themeDisplay.getDevice();
        }
        return UnknownDevice.getInstance();
    }

    protected String getErrorTemplateId(String errorTemplatePropertyKey, String langType) {
        return PropsUtil.get(errorTemplatePropertyKey, new Filter(langType));
    }

    protected TemplateResource getErrorTemplateResource(String langType) {
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            String errorTemplateId = this.errorTemplateIds.get(langType);
            URL url = classLoader.getResource(errorTemplateId);
            return new URLTemplateResource(errorTemplateId, url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Template getTemplate(String templateId, String script, String langType) throws Exception {
        StringTemplateResource templateResource = new StringTemplateResource(templateId, script);
        TemplateResource errorTemplateResource = this.getErrorTemplateResource(langType);
        return TemplateManagerUtil.getTemplate((String)langType, (TemplateResource)templateResource, (TemplateResource)errorTemplateResource, (boolean)this._restricted);
    }

    protected String getTemplateId(String templateId, long companyId, long companyGroupId, long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("#");
        if (companyGroupId > 0L) {
            sb.append(companyGroupId);
        } else {
            sb.append(groupId);
        }
        sb.append("#");
        sb.append(templateId);
        return sb.toString();
    }

    protected String getTemplatesPath(long companyId, long groupId, long classNameId) {
        StringBundler sb = new StringBundler(7);
        sb.append("_TEMPLATE_CONTEXT_");
        sb.append("/");
        sb.append(companyId);
        sb.append("/");
        sb.append(groupId);
        sb.append("/");
        sb.append(classNameId);
        return sb.toString();
    }

    protected void mergeTemplate(Template template, UnsyncStringWriter unsyncStringWriter, boolean propagateException) throws Exception {
        if (propagateException) {
            template.doProcessTemplate((Writer)unsyncStringWriter);
        } else {
            template.processTemplate((Writer)unsyncStringWriter);
        }
    }

    protected void prepareTemplate(ThemeDisplay themeDisplay, Template template) throws Exception {
        if (themeDisplay == null) {
            return;
        }
        template.prepare(themeDisplay.getRequest());
    }

    protected void setErrorTemplateIds(String errorTemplatePropertyKey) {
        Set langTypes = TemplateManagerUtil.getTemplateManagerNames();
        for (String langType : langTypes) {
            String errorTemplateId = this.getErrorTemplateId(errorTemplatePropertyKey, langType);
            if (!Validator.isNotNull((String)errorTemplateId)) continue;
            this.errorTemplateIds.put(langType, errorTemplateId);
        }
    }

    protected void setTransformerListeners(String transformerListenerPropertyKey, ClassLoader classLoader) {
        Set transformerListenerClassNames = SetUtil.fromArray((Object[])PropsUtil.getArray(transformerListenerPropertyKey));
        for (String transformerListenerClassName : transformerListenerClassNames) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiating transformer listener " + transformerListenerClassName));
                }
                TransformerListener transformerListener = (TransformerListener)InstanceFactory.newInstance((ClassLoader)classLoader, (String)transformerListenerClassName);
                this.transformerListeners.add(transformerListener);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }
}

