/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.systemevent;

import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.TypedModel;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class SystemEventAdvice
extends AnnotationChainableMethodAdvice<SystemEvent> {
    private static final int _PHASE_AFTER_RETURNING = 1;
    private static final int _PHASE_BEFORE = 0;
    private static final int _PHASE_DURING_FINALLY = 2;
    private static final Log _log = LogFactoryUtil.getLog(SystemEventAdvice.class);
    private static final SystemEvent _nullSystemEvent = new SystemEvent(){

        public Class<? extends Annotation> annotationType() {
            return SystemEvent.class;
        }

        public int action() {
            return 0;
        }

        public boolean send() {
            return false;
        }

        public int type() {
            return 0;
        }
    };

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        SystemEvent systemEvent = (SystemEvent)this.findAnnotation(methodInvocation);
        if (systemEvent == _nullSystemEvent || !systemEvent.send()) {
            return;
        }
        if (!this.isValid(methodInvocation, 1)) {
            return;
        }
        Object[] arguments = methodInvocation.getArguments();
        ClassedModel classedModel = (ClassedModel)arguments[0];
        long groupId = this.getGroupId(classedModel);
        String className = this.getClassName(classedModel);
        String referrerClassName = null;
        if (classedModel instanceof TypedModel) {
            TypedModel typedModel = (TypedModel)classedModel;
            referrerClassName = typedModel.getClassName();
        }
        long classPK = this.getClassPK(classedModel);
        SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek();
        if (systemEventHierarchyEntry != null && systemEventHierarchyEntry.hasTypedModel(className, classPK)) {
            if (groupId > 0L) {
                SystemEventLocalServiceUtil.addSystemEvent((long)0L, (long)groupId, (String)systemEventHierarchyEntry.getClassName(), (long)classPK, (String)systemEventHierarchyEntry.getUuid(), (String)referrerClassName, (int)systemEvent.type(), (String)systemEventHierarchyEntry.getExtraData());
            } else {
                SystemEventLocalServiceUtil.addSystemEvent((long)this.getCompanyId(classedModel), (String)systemEventHierarchyEntry.getClassName(), (long)classPK, (String)systemEventHierarchyEntry.getUuid(), (String)referrerClassName, (int)systemEvent.type(), (String)systemEventHierarchyEntry.getExtraData());
            }
        } else if (groupId > 0L) {
            SystemEventLocalServiceUtil.addSystemEvent((long)0L, (long)groupId, (String)className, (long)classPK, (String)this.getUuid(classedModel), (String)referrerClassName, (int)systemEvent.type(), (String)"");
        } else {
            SystemEventLocalServiceUtil.addSystemEvent((long)this.getCompanyId(classedModel), (String)className, (long)classPK, (String)this.getUuid(classedModel), (String)referrerClassName, (int)systemEvent.type(), (String)"");
        }
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        SystemEvent systemEvent = (SystemEvent)this.findAnnotation(methodInvocation);
        if (systemEvent == _nullSystemEvent) {
            return null;
        }
        if (systemEvent.action() != 0) {
            if (!this.isValid(methodInvocation, 0)) {
                return null;
            }
            Object[] arguments = methodInvocation.getArguments();
            ClassedModel classedModel = (ClassedModel)arguments[0];
            SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.push((String)this.getClassName(classedModel), (long)this.getClassPK(classedModel), (int)systemEvent.action());
            if (systemEventHierarchyEntry != null) {
                systemEventHierarchyEntry.setUuid(this.getUuid(classedModel));
            }
        }
        return null;
    }

    @Override
    public void duringFinally(MethodInvocation methodInvocation) {
        SystemEvent systemEvent = (SystemEvent)this.findAnnotation(methodInvocation);
        if (systemEvent == _nullSystemEvent) {
            return;
        }
        if (!this.isValid(methodInvocation, 2)) {
            return;
        }
        if (systemEvent.action() == 0) {
            return;
        }
        Object[] arguments = methodInvocation.getArguments();
        ClassedModel classedModel = (ClassedModel)arguments[0];
        long classPK = this.getClassPK(classedModel);
        if (classPK == 0L) {
            return;
        }
        SystemEventHierarchyEntryThreadLocal.pop((String)this.getClassName(classedModel), (long)classPK);
    }

    @Override
    public SystemEvent getNullAnnotation() {
        return _nullSystemEvent;
    }

    protected String getClassName(ClassedModel classedModel) {
        String className = classedModel.getModelClassName();
        if (classedModel instanceof StagedModel) {
            StagedModel stagedModel = (StagedModel)classedModel;
            StagedModelType stagedModelType = stagedModel.getStagedModelType();
            className = stagedModelType.getClassName();
        }
        return className;
    }

    protected long getClassPK(ClassedModel classedModel) {
        Serializable primaryKeyObj = classedModel.getPrimaryKeyObj();
        if (!(primaryKeyObj instanceof Long)) {
            return 0L;
        }
        return (Long)primaryKeyObj;
    }

    protected long getCompanyId(ClassedModel classedModel) {
        if (classedModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)classedModel;
            return auditedModel.getCompanyId();
        }
        if (classedModel instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)classedModel;
            return groupedModel.getCompanyId();
        }
        if (classedModel instanceof StagedModel) {
            StagedModel stagedModel = (StagedModel)classedModel;
            return stagedModel.getCompanyId();
        }
        return 0L;
    }

    protected long getGroupId(ClassedModel classedModel) {
        if (!(classedModel instanceof GroupedModel)) {
            return 0L;
        }
        GroupedModel groupedModel = (GroupedModel)classedModel;
        return groupedModel.getGroupId();
    }

    protected String getUuid(ClassedModel classedModel) throws Exception {
        if (classedModel instanceof StagedModel) {
            StagedModel stagedModel = (StagedModel)classedModel;
            return stagedModel.getUuid();
        }
        Method getUuidMethod = null;
        try {
            Class<?> modelClass = classedModel.getClass();
            getUuidMethod = modelClass.getMethod("getUuid", new Class[0]);
        }
        catch (Exception e2) {
            return "";
        }
        return (String)getUuidMethod.invoke((Object)classedModel, new Object[0]);
    }

    protected boolean isValid(MethodInvocation methodInvocation, int phase) {
        Method method = methodInvocation.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            if (_log.isDebugEnabled() && phase == 0) {
                _log.debug((Object)("The method " + methodInvocation + " must have at least one parameter"));
            }
            return false;
        }
        Class<?> parameterType = parameterTypes[0];
        if (!ClassedModel.class.isAssignableFrom(parameterType)) {
            if (_log.isDebugEnabled() && phase == 0) {
                _log.debug((Object)("The first parameter of " + methodInvocation + " must implement ClassedModel"));
            }
            return false;
        }
        Object[] arguments = methodInvocation.getArguments();
        ClassedModel classedModel = (ClassedModel)arguments[0];
        if (classedModel == null || !(classedModel.getPrimaryKeyObj() instanceof Long)) {
            if (_log.isDebugEnabled() && phase == 0) {
                _log.debug((Object)("The first parameter of " + methodInvocation + " must be a long"));
            }
            return false;
        }
        if (phase != 1) {
            return true;
        }
        if (!(AuditedModel.class.isAssignableFrom(parameterType) || GroupedModel.class.isAssignableFrom(parameterType) || StagedModel.class.isAssignableFrom(parameterType))) {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("If send is true, the first parameter of ");
                sb.append((Object)methodInvocation);
                sb.append(" must implement AuditedModel, GroupedModel, or ");
                sb.append("StagedModel");
                _log.debug((Object)sb.toString());
            }
            return false;
        }
        return true;
    }
}

