/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.SharedSessionServletRequest;
import com.liferay.portal.util.PropsValues;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class JSONAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(JSONAction.class);
    private final Set<String> _hostsAllowed = SetUtil.fromArray((Object[])PropsValues.JSON_SERVICE_AUTH_TOKEN_HOSTS_ALLOWED);
    private ServletContext _servletContext;

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.rerouteExecute(request, response)) {
            return null;
        }
        String callback = ParamUtil.getString((HttpServletRequest)request, (String)"callback");
        String json = null;
        try {
            this.checkAuthToken(request);
            json = this.getJSON(actionMapping, actionForm, request, response);
            if (Validator.isNotNull((String)callback)) {
                StringBundler sb = new StringBundler(5);
                sb.append("/**/");
                sb.append(callback);
                sb.append("(");
                sb.append(json);
                sb.append(")");
                json = sb.toString();
            }
        }
        catch (SecurityException se) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)se.getMessage());
            }
            json = JSONFactoryUtil.serializeThrowable((Throwable)se);
        }
        catch (Exception e2) {
            _log.error((Object)e2.getMessage());
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
        boolean refresh = ParamUtil.getBoolean((HttpServletRequest)request, (String)"refresh");
        if (refresh) {
            return actionMapping.findForward("/common/referer_js.jsp");
        }
        if (Validator.isNotNull((String)json)) {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            try (ServletOutputStream outputStream = response.getOutputStream();){
                byte[] bytes = json.getBytes("UTF-8");
                outputStream.write(bytes);
            }
        }
        return null;
    }

    public abstract String getJSON(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected void checkAuthToken(HttpServletRequest request) throws PortalException {
        String authType = GetterUtil.getString((String)request.getAuthType());
        if (AccessControlUtil.getAccessControlContext() == null ? authType.equals("BASIC") || authType.equals("DIGEST") : !authType.equals("FORM")) {
            return;
        }
        if (PropsValues.JSON_SERVICE_AUTH_TOKEN_ENABLED && !AccessControlUtil.isAccessAllowed((HttpServletRequest)request, this._hostsAllowed)) {
            AuthTokenUtil.checkCSRFToken((HttpServletRequest)request, (String)this.getCSRFOrigin(request));
        }
    }

    protected String getCSRFOrigin(HttpServletRequest request) {
        return ClassUtil.getClassName((Object)((Object)this));
    }

    protected String getReroutePath() {
        return null;
    }

    protected boolean rerouteExecute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String servletContextName;
        String reroutePath = this.getReroutePath();
        if (Validator.isNull((String)reroutePath)) {
            return false;
        }
        String requestServletContextName = ParamUtil.getString((HttpServletRequest)request, (String)"servletContextName");
        if (Validator.isNull((String)requestServletContextName)) {
            return false;
        }
        ServletContext servletContext = this._servletContext;
        if (servletContext == null) {
            servletContext = (ServletContext)request.getAttribute("CTX");
        }
        if ((servletContextName = GetterUtil.getString((String)servletContext.getServletContextName())).equals(requestServletContextName)) {
            return false;
        }
        ServletContext requestServletContext = ServletContextPool.get((String)requestServletContextName);
        if (requestServletContext == null) {
            return false;
        }
        RequestDispatcher requestDispatcher = requestServletContext.getRequestDispatcher(reroutePath);
        if (requestDispatcher == null) {
            return false;
        }
        requestDispatcher.forward((ServletRequest)new SharedSessionServletRequest(request, true), (ServletResponse)response);
        return true;
    }
}

