/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class CounterTransactionExecutor
implements TransactionExecutor,
TransactionHandler {
    private static final Log _log = LogFactoryUtil.getLog(CounterTransactionExecutor.class);

    @Override
    public void commit(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) {
        try {
            platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
        }
        catch (RuntimeException re) {
            _log.error((Object)"Application exception overridden by commit exception", (Throwable)re);
            throw re;
        }
        catch (Error e2) {
            _log.error((Object)"Application exception overridden by commit error", (Throwable)e2);
            throw e2;
        }
    }

    @Override
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) throws Throwable {
        TransactionStatusAdapter transactionStatusAdapter = this.start(platformTransactionManager, transactionAttributeAdapter);
        Object returnValue = null;
        try {
            returnValue = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.rollback(platformTransactionManager, throwable, transactionAttributeAdapter, transactionStatusAdapter);
        }
        this.commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter);
        return returnValue;
    }

    @Override
    public void rollback(PlatformTransactionManager platformTransactionManager, Throwable throwable, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) throws Throwable {
        if (transactionAttributeAdapter.rollbackOn(throwable)) {
            try {
                platformTransactionManager.rollback(transactionStatusAdapter.getTransactionStatus());
            }
            catch (RuntimeException re) {
                re.addSuppressed(throwable);
                _log.error((Object)"Application exception overridden by rollback exception", (Throwable)re);
                throw re;
            }
            catch (Error e2) {
                e2.addSuppressed(throwable);
                _log.error((Object)"Application exception overridden by rollback error", (Throwable)e2);
                throw e2;
            }
        } else {
            this.commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter);
        }
        throw throwable;
    }

    @Override
    public TransactionStatusAdapter start(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter) {
        return new TransactionStatusAdapter(platformTransactionManager.getTransaction((TransactionDefinition)transactionAttributeAdapter));
    }
}

