/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.AspectJPointcutAdvisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class PortletBeanFactoryCleaner
implements BeanFactoryAware {
    private static final Field _SHADOW_MATCH_CACHE_FIELD;
    private static final Log _log;
    private static final Set<AspectJExpressionPointcut> _aspectJExpressionPointcuts;
    private static BeanFactory _beanFactory;
    private static final Set<BeanFactoryAware> _beanFactoryAwares;

    public static void readBeans() {
        String[] names;
        if (_beanFactory == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Bean factory is null");
            }
            return;
        }
        if (!(_beanFactory instanceof ListableBeanFactory)) {
            return;
        }
        ListableBeanFactory listableBeanFactory = (ListableBeanFactory)_beanFactory;
        for (String name : names = listableBeanFactory.getBeanDefinitionNames()) {
            try {
                PortletBeanFactoryCleaner._readBean(listableBeanFactory, name);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        for (BeanFactoryAware beanFactoryAware : _beanFactoryAwares) {
            try {
                beanFactoryAware.setBeanFactory(null);
            }
            catch (Exception e2) {}
        }
        _beanFactoryAwares.clear();
        for (AspectJExpressionPointcut aspectJExpressionPointcut : _aspectJExpressionPointcuts) {
            try {
                Map shadowMatchCache = (Map)_SHADOW_MATCH_CACHE_FIELD.get(aspectJExpressionPointcut);
                shadowMatchCache.clear();
            }
            catch (Exception exception) {}
        }
        _aspectJExpressionPointcuts.clear();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        _beanFactory = beanFactory;
    }

    private static void _readBean(ListableBeanFactory listableBeanFactory, String name) throws Exception {
        Object bean = listableBeanFactory.getBean(name);
        if (bean instanceof AspectJPointcutAdvisor) {
            AspectJPointcutAdvisor aspectJPointcutAdvisor = (AspectJPointcutAdvisor)bean;
            Pointcut pointcut = aspectJPointcutAdvisor.getPointcut();
            ClassFilter classFilter = pointcut.getClassFilter();
            if (classFilter instanceof AspectJExpressionPointcut) {
                AspectJExpressionPointcut aspectJExpressionPointcut = (AspectJExpressionPointcut)classFilter;
                _beanFactoryAwares.add((BeanFactoryAware)aspectJExpressionPointcut);
                _aspectJExpressionPointcuts.add(aspectJExpressionPointcut);
            }
        } else if (bean instanceof BeanFactoryAware) {
            _beanFactoryAwares.add((BeanFactoryAware)bean);
        }
    }

    static {
        _log = LogFactoryUtil.getLog(PortletBeanFactoryCleaner.class);
        _aspectJExpressionPointcuts = new HashSet<AspectJExpressionPointcut>();
        _beanFactoryAwares = new HashSet<BeanFactoryAware>();
        try {
            _SHADOW_MATCH_CACHE_FIELD = ReflectionUtil.getDeclaredField(AspectJExpressionPointcut.class, (String)"shadowMatchCache");
        }
        catch (Exception e2) {
            throw new LoggedExceptionInInitializerError((Throwable)e2);
        }
    }
}

