/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.secure;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsUtil;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SecureFilter
extends BasePortalFilter {
    private static final String _AUTHENTICATED_USER = SecureFilter.class + "_AUTHENTICATED_USER";
    private static final Log _log = LogFactoryUtil.getLog(SecureFilter.class);
    private boolean _basicAuthEnabled;
    private boolean _digestAuthEnabled;
    private final Set<String> _hostsAllowed = new HashSet<String>();
    private boolean _httpsRequired;
    private boolean _usePermissionChecker;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._basicAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("basic_auth"));
        this._digestAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("digest_auth"));
        String propertyPrefix = filterConfig.getInitParameter("portal_property_prefix");
        String[] hostsAllowed = null;
        if (Validator.isNull((String)propertyPrefix)) {
            hostsAllowed = StringUtil.split((String)filterConfig.getInitParameter("hosts.allowed"));
            this._httpsRequired = GetterUtil.getBoolean((String)filterConfig.getInitParameter("https.required"));
        } else {
            hostsAllowed = PropsUtil.getArray(propertyPrefix + "hosts.allowed");
            this._httpsRequired = GetterUtil.getBoolean((String)PropsUtil.get(propertyPrefix + "https.required"));
        }
        for (String hostAllowed : hostsAllowed) {
            this._hostsAllowed.add(hostAllowed);
        }
        this._usePermissionChecker = GetterUtil.getBoolean((String)filterConfig.getInitParameter("use_permission_checker"));
    }

    protected HttpServletRequest basicAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        long userId = GetterUtil.getLong((String)((String)session.getAttribute(_AUTHENTICATED_USER)));
        if (userId > 0L) {
            request = new ProtectedServletRequest(request, String.valueOf(userId), "BASIC");
            this.initThreadLocals(request);
        } else {
            try {
                userId = HttpAuthManagerUtil.getBasicUserId((HttpServletRequest)request);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            if (userId > 0L) {
                request = this.setCredentials(request, session, userId, "BASIC");
            } else {
                HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Basic");
                HttpAuthManagerUtil.generateChallenge((HttpServletRequest)request, (HttpServletResponse)response, (HttpAuthorizationHeader)httpAuthorizationHeader);
                return null;
            }
        }
        return request;
    }

    protected HttpServletRequest digestAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        long userId = GetterUtil.getLong((String)((String)session.getAttribute(_AUTHENTICATED_USER)));
        if (userId > 0L) {
            request = new ProtectedServletRequest(request, String.valueOf(userId), "DIGEST");
            this.initThreadLocals(request);
        } else {
            try {
                userId = HttpAuthManagerUtil.getDigestUserId((HttpServletRequest)request);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            if (userId > 0L) {
                request = this.setCredentials(request, session, userId, "DIGEST");
            } else {
                HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Digest");
                HttpAuthManagerUtil.generateChallenge((HttpServletRequest)request, (HttpServletResponse)response, (HttpAuthorizationHeader)httpAuthorizationHeader);
                return null;
            }
        }
        return request;
    }

    protected void initThreadLocals(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        User user = (User)session.getAttribute("USER");
        this.initThreadLocals(user);
        PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)request));
    }

    protected void initThreadLocals(User user) throws Exception {
        CompanyThreadLocal.setCompanyId((Long)user.getCompanyId());
        PrincipalThreadLocal.setName((long)user.getUserId());
        if (!this._usePermissionChecker) {
            return;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            return;
        }
        permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String remoteAddr = request.getRemoteAddr();
        if (AccessControlUtil.isAccessAllowed((HttpServletRequest)request, this._hostsAllowed)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + remoteAddr));
            }
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Access denied for " + remoteAddr));
            }
            response.sendError(403, "Access denied for " + remoteAddr);
            return;
        }
        if (_log.isDebugEnabled()) {
            if (this._httpsRequired) {
                _log.debug((Object)"https is required");
            } else {
                _log.debug((Object)"https is not required");
            }
        }
        if (this._httpsRequired && !request.isSecure()) {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Securing " + completeURL));
            }
            StringBundler redirectURL = new StringBundler(5);
            redirectURL.append("https://");
            redirectURL.append(request.getServerName());
            redirectURL.append(request.getServletPath());
            String queryString = request.getQueryString();
            if (Validator.isNotNull((String)queryString)) {
                redirectURL.append("?");
                redirectURL.append(request.getQueryString());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Redirect to " + redirectURL));
            }
            response.sendRedirect(redirectURL.toString());
        } else {
            String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not securing " + completeURL));
            }
            User user = null;
            try {
                user = PortalUtil.initUser((HttpServletRequest)request);
            }
            catch (NoSuchUserException nsue) {
                response.sendRedirect(completeURL);
                return;
            }
            this.initThreadLocals(user);
            if (!user.isDefaultUser()) {
                request = this.setCredentials(request, request.getSession(), user.getUserId(), null);
            } else if (this._digestAuthEnabled) {
                request = this.digestAuth(request, response);
            } else if (this._basicAuthEnabled) {
                request = this.basicAuth(request, response);
            }
            if (request != null) {
                Class<?> clazz = ((Object)((Object)this)).getClass();
                this.processFilter(clazz.getName(), request, response, filterChain);
            }
        }
    }

    protected HttpServletRequest setCredentials(HttpServletRequest request, HttpSession session, long userId, String authType) throws Exception {
        User user = UserLocalServiceUtil.getUser((long)userId);
        String userIdString = String.valueOf(userId);
        request = new ProtectedServletRequest(request, userIdString, authType);
        session.setAttribute(_AUTHENTICATED_USER, (Object)userIdString);
        session.setAttribute("USER", (Object)user);
        this.initThreadLocals(request);
        return request;
    }

    protected void setUsePermissionChecker(boolean usePermissionChecker) {
        this._usePermissionChecker = usePermissionChecker;
    }
}

