/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class I18nServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(I18nServlet.class);
    private static Set<String> _languageIds;

    public static Set<String> getLanguageIds() {
        return _languageIds;
    }

    public static void setLanguageIds(Element root) {
        _languageIds = new HashSet<String>();
        List rootElements = root.elements("servlet-mapping");
        for (Element element : rootElements) {
            String servletName = element.elementText("servlet-name");
            if (!servletName.equals("I18n Servlet")) continue;
            String urlPattern = element.elementText("url-pattern");
            String languageId = urlPattern.substring(0, urlPattern.lastIndexOf(47));
            _languageIds.add(languageId);
        }
        _languageIds = Collections.unmodifiableSet(_languageIds);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            I18nData i18nData = this.getI18nData(request);
            if (i18nData == null || !PortalUtil.isValidResourceId((String)i18nData.getPath())) {
                PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException()), (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                request.setAttribute("I18N_LANGUAGE_CODE", (Object)i18nData.getLanguageCode());
                request.setAttribute("I18N_LANGUAGE_ID", (Object)i18nData.getLanguageId());
                request.setAttribute("I18N_PATH", (Object)i18nData.getI18nPath());
                Locale locale = LocaleUtil.fromLanguageId((String)i18nData.getLanguageId(), (boolean)false, (boolean)false);
                HttpSession session = request.getSession();
                session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
                LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
                ServletContext servletContext = this.getServletContext();
                RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(i18nData.getPath());
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected I18nData getI18nData(HttpServletRequest request) {
        String path = GetterUtil.getString((String)request.getPathInfo());
        if (Validator.isNull((String)path)) {
            return null;
        }
        String i18nLanguageId = request.getServletPath();
        int pos = i18nLanguageId.lastIndexOf(47);
        i18nLanguageId = i18nLanguageId.substring(pos + 1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Language ID " + i18nLanguageId));
        }
        if (Validator.isNull((String)i18nLanguageId)) {
            return null;
        }
        String i18nPath = "/" + i18nLanguageId;
        Locale locale = LocaleUtil.fromLanguageId((String)i18nLanguageId, (boolean)true, (boolean)false);
        String i18nLanguageCode = i18nLanguageId;
        if (locale == null || Validator.isNull((String)locale.getCountry())) {
            locale = LanguageUtil.getLocale((String)i18nLanguageCode);
        }
        if (locale != null) {
            i18nLanguageId = LocaleUtil.toLanguageId((Locale)locale);
            i18nLanguageCode = locale.getLanguage();
        }
        if (!PropsValues.LOCALE_USE_DEFAULT_IF_NOT_AVAILABLE && !LanguageUtil.isAvailableLocale((String)i18nLanguageId)) {
            return null;
        }
        String redirect = path;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect " + redirect));
        }
        return new I18nData(i18nPath, i18nLanguageCode, i18nLanguageId, redirect);
    }

    protected I18nData getI18nData(Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return new I18nData("/" + languageId, locale.getLanguage(), languageId, "/");
    }

    protected class I18nData {
        private final String _i18nPath;
        private final String _languageCode;
        private final String _languageId;
        private final String _path;

        public I18nData(String i18nPath, String languageCode, String languageId, String path) {
            this._i18nPath = i18nPath;
            this._languageCode = languageCode;
            this._languageId = languageId;
            this._path = path;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof I18nData)) {
                return false;
            }
            I18nData i18nData = (I18nData)obj;
            return Objects.equals(this.getI18nPath(), i18nData.getI18nPath()) && Objects.equals(this.getLanguageCode(), i18nData.getLanguageCode()) && Objects.equals(this.getLanguageId(), i18nData.getLanguageId()) && Objects.equals(this.getPath(), i18nData.getPath());
        }

        public String getI18nPath() {
            return this._i18nPath;
        }

        public String getLanguageCode() {
            return this._languageCode;
        }

        public String getLanguageId() {
            return this._languageId;
        }

        public String getPath() {
            return this._path;
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)this.getI18nPath());
            hash = HashUtil.hash((int)hash, (Object)this.getLanguageCode());
            hash = HashUtil.hash((int)hash, (Object)this.getLanguageId());
            return HashUtil.hash((int)hash, (Object)this.getPath());
        }
    }
}

