/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchResourceBlockException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourceBlock;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.ResourceBlockPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.impl.ResourceBlockImpl;
import com.liferay.portal.model.impl.ResourceBlockModelImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class ResourceBlockPersistenceImpl
extends BasePersistenceImpl<ResourceBlock>
implements ResourceBlockPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ResourceBlockImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, ResourceBlockImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, ResourceBlockImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_C_N = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, ResourceBlockImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_N", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_N = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, ResourceBlockImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_N", new String[]{Long.class.getName(), String.class.getName()}, 5L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_N = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_N", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_C_N_COMPANYID_2 = "resourceBlock.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_N_NAME_1 = "resourceBlock.name IS NULL";
    private static final String _FINDER_COLUMN_C_N_NAME_2 = "resourceBlock.name = ?";
    private static final String _FINDER_COLUMN_C_N_NAME_3 = "(resourceBlock.name IS NULL OR resourceBlock.name = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_C_G_N = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, ResourceBlockImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_G_N", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_G_N = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, ResourceBlockImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_G_N", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, 7L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_G_N = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_G_N", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_C_G_N_COMPANYID_2 = "resourceBlock.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_G_N_GROUPID_2 = "resourceBlock.groupId = ? AND ";
    private static final String _FINDER_COLUMN_C_G_N_NAME_1 = "resourceBlock.name IS NULL";
    private static final String _FINDER_COLUMN_C_G_N_NAME_2 = "resourceBlock.name = ?";
    private static final String _FINDER_COLUMN_C_G_N_NAME_3 = "(resourceBlock.name IS NULL OR resourceBlock.name = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_C_G_N_P = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, ResourceBlockImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_G_N_P", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()}, 15L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_G_N_P = new FinderPath(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_G_N_P", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_C_G_N_P_COMPANYID_2 = "resourceBlock.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_G_N_P_GROUPID_2 = "resourceBlock.groupId = ? AND ";
    private static final String _FINDER_COLUMN_C_G_N_P_NAME_1 = "resourceBlock.name IS NULL AND ";
    private static final String _FINDER_COLUMN_C_G_N_P_NAME_2 = "resourceBlock.name = ? AND ";
    private static final String _FINDER_COLUMN_C_G_N_P_NAME_3 = "(resourceBlock.name IS NULL OR resourceBlock.name = '') AND ";
    private static final String _FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_1 = "resourceBlock.permissionsHash IS NULL";
    private static final String _FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_2 = "resourceBlock.permissionsHash = ?";
    private static final String _FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_3 = "(resourceBlock.permissionsHash IS NULL OR resourceBlock.permissionsHash = '')";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    protected EntityCache entityCache = EntityCacheUtil.getEntityCache();
    protected FinderCache finderCache = FinderCacheUtil.getFinderCache();
    private static final String _SQL_SELECT_RESOURCEBLOCK = "SELECT resourceBlock FROM ResourceBlock resourceBlock";
    private static final String _SQL_SELECT_RESOURCEBLOCK_WHERE_PKS_IN = "SELECT resourceBlock FROM ResourceBlock resourceBlock WHERE resourceBlockId IN (";
    private static final String _SQL_SELECT_RESOURCEBLOCK_WHERE = "SELECT resourceBlock FROM ResourceBlock resourceBlock WHERE ";
    private static final String _SQL_COUNT_RESOURCEBLOCK = "SELECT COUNT(resourceBlock) FROM ResourceBlock resourceBlock";
    private static final String _SQL_COUNT_RESOURCEBLOCK_WHERE = "SELECT COUNT(resourceBlock) FROM ResourceBlock resourceBlock WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "resourceBlock.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ResourceBlock exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ResourceBlock exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ResourceBlockPersistenceImpl.class);

    public List<ResourceBlock> findByC_N(long companyId, String name) {
        return this.findByC_N(companyId, name, -1, -1, null);
    }

    public List<ResourceBlock> findByC_N(long companyId, String name, int start, int end) {
        return this.findByC_N(companyId, name, start, end, null);
    }

    public List<ResourceBlock> findByC_N(long companyId, String name, int start, int end, OrderByComparator<ResourceBlock> orderByComparator) {
        return this.findByC_N(companyId, name, start, end, orderByComparator, true);
    }

    public List<ResourceBlock> findByC_N(long companyId, String name, int start, int end, OrderByComparator<ResourceBlock> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_N;
            finderArgs = new Object[]{companyId, name};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_C_N;
            finderArgs = new Object[]{companyId, name, start, end, orderByComparator};
        }
        List<ResourceBlock> list = null;
        if (retrieveFromCache && (list = (List<ResourceBlock>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ResourceBlock resourceBlock : list) {
                if (companyId == resourceBlock.getCompanyId() && Objects.equals(name, resourceBlock.getName())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_RESOURCEBLOCK_WHERE);
            query.append("resourceBlock.companyId = ? AND ");
            boolean bindName = false;
            if (name == null) {
                query.append("resourceBlock.name IS NULL");
            } else if (name.equals("")) {
                query.append("(resourceBlock.name IS NULL OR resourceBlock.name = '')");
            } else {
                bindName = true;
                query.append("resourceBlock.name = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY resourceBlock.resourceBlockId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (bindName) {
                    qPos.add(name);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e2) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ResourceBlock findByC_N_First(long companyId, String name, OrderByComparator<ResourceBlock> orderByComparator) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.fetchByC_N_First(companyId, name, orderByComparator);
        if (resourceBlock != null) {
            return resourceBlock;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", name=");
        msg.append(name);
        msg.append("}");
        throw new NoSuchResourceBlockException(msg.toString());
    }

    public ResourceBlock fetchByC_N_First(long companyId, String name, OrderByComparator<ResourceBlock> orderByComparator) {
        List<ResourceBlock> list = this.findByC_N(companyId, name, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ResourceBlock findByC_N_Last(long companyId, String name, OrderByComparator<ResourceBlock> orderByComparator) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.fetchByC_N_Last(companyId, name, orderByComparator);
        if (resourceBlock != null) {
            return resourceBlock;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", name=");
        msg.append(name);
        msg.append("}");
        throw new NoSuchResourceBlockException(msg.toString());
    }

    public ResourceBlock fetchByC_N_Last(long companyId, String name, OrderByComparator<ResourceBlock> orderByComparator) {
        int count = this.countByC_N(companyId, name);
        if (count == 0) {
            return null;
        }
        List<ResourceBlock> list = this.findByC_N(companyId, name, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ResourceBlock[] findByC_N_PrevAndNext(long resourceBlockId, long companyId, String name, OrderByComparator<ResourceBlock> orderByComparator) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.findByPrimaryKey(resourceBlockId);
        Session session = null;
        try {
            session = this.openSession();
            ResourceBlock[] array = new ResourceBlockImpl[]{this.getByC_N_PrevAndNext(session, resourceBlock, companyId, name, orderByComparator, true), resourceBlock, this.getByC_N_PrevAndNext(session, resourceBlock, companyId, name, orderByComparator, false)};
            ResourceBlock[] resourceBlockArray = array;
            return resourceBlockArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ResourceBlock getByC_N_PrevAndNext(Session session, ResourceBlock resourceBlock, long companyId, String name, OrderByComparator<ResourceBlock> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_RESOURCEBLOCK_WHERE);
        query.append("resourceBlock.companyId = ? AND ");
        boolean bindName = false;
        if (name == null) {
            query.append("resourceBlock.name IS NULL");
        } else if (name.equals("")) {
            query.append("(resourceBlock.name IS NULL OR resourceBlock.name = '')");
        } else {
            bindName = true;
            query.append("resourceBlock.name = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY resourceBlock.resourceBlockId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        if (bindName) {
            qPos.add(name);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)resourceBlock)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ResourceBlock)list.get(1);
        }
        return null;
    }

    public void removeByC_N(long companyId, String name) {
        for (ResourceBlock resourceBlock : this.findByC_N(companyId, name, -1, -1, null)) {
            this.remove((BaseModel)resourceBlock);
        }
    }

    public int countByC_N(long companyId, String name) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_N;
        Object[] finderArgs = new Object[]{companyId, name};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_RESOURCEBLOCK_WHERE);
            query.append("resourceBlock.companyId = ? AND ");
            boolean bindName = false;
            if (name == null) {
                query.append("resourceBlock.name IS NULL");
            } else if (name.equals("")) {
                query.append("(resourceBlock.name IS NULL OR resourceBlock.name = '')");
            } else {
                bindName = true;
                query.append("resourceBlock.name = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (bindName) {
                    qPos.add(name);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e2) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ResourceBlock> findByC_G_N(long companyId, long groupId, String name) {
        return this.findByC_G_N(companyId, groupId, name, -1, -1, null);
    }

    public List<ResourceBlock> findByC_G_N(long companyId, long groupId, String name, int start, int end) {
        return this.findByC_G_N(companyId, groupId, name, start, end, null);
    }

    public List<ResourceBlock> findByC_G_N(long companyId, long groupId, String name, int start, int end, OrderByComparator<ResourceBlock> orderByComparator) {
        return this.findByC_G_N(companyId, groupId, name, start, end, orderByComparator, true);
    }

    public List<ResourceBlock> findByC_G_N(long companyId, long groupId, String name, int start, int end, OrderByComparator<ResourceBlock> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_G_N;
            finderArgs = new Object[]{companyId, groupId, name};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_C_G_N;
            finderArgs = new Object[]{companyId, groupId, name, start, end, orderByComparator};
        }
        List<ResourceBlock> list = null;
        if (retrieveFromCache && (list = (List<ResourceBlock>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ResourceBlock resourceBlock : list) {
                if (companyId == resourceBlock.getCompanyId() && groupId == resourceBlock.getGroupId() && Objects.equals(name, resourceBlock.getName())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_RESOURCEBLOCK_WHERE);
            query.append("resourceBlock.companyId = ? AND ");
            query.append("resourceBlock.groupId = ? AND ");
            boolean bindName = false;
            if (name == null) {
                query.append("resourceBlock.name IS NULL");
            } else if (name.equals("")) {
                query.append("(resourceBlock.name IS NULL OR resourceBlock.name = '')");
            } else {
                bindName = true;
                query.append("resourceBlock.name = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY resourceBlock.resourceBlockId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e2) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ResourceBlock findByC_G_N_First(long companyId, long groupId, String name, OrderByComparator<ResourceBlock> orderByComparator) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.fetchByC_G_N_First(companyId, groupId, name, orderByComparator);
        if (resourceBlock != null) {
            return resourceBlock;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", groupId=");
        msg.append(groupId);
        msg.append(", name=");
        msg.append(name);
        msg.append("}");
        throw new NoSuchResourceBlockException(msg.toString());
    }

    public ResourceBlock fetchByC_G_N_First(long companyId, long groupId, String name, OrderByComparator<ResourceBlock> orderByComparator) {
        List<ResourceBlock> list = this.findByC_G_N(companyId, groupId, name, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ResourceBlock findByC_G_N_Last(long companyId, long groupId, String name, OrderByComparator<ResourceBlock> orderByComparator) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.fetchByC_G_N_Last(companyId, groupId, name, orderByComparator);
        if (resourceBlock != null) {
            return resourceBlock;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", groupId=");
        msg.append(groupId);
        msg.append(", name=");
        msg.append(name);
        msg.append("}");
        throw new NoSuchResourceBlockException(msg.toString());
    }

    public ResourceBlock fetchByC_G_N_Last(long companyId, long groupId, String name, OrderByComparator<ResourceBlock> orderByComparator) {
        int count = this.countByC_G_N(companyId, groupId, name);
        if (count == 0) {
            return null;
        }
        List<ResourceBlock> list = this.findByC_G_N(companyId, groupId, name, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ResourceBlock[] findByC_G_N_PrevAndNext(long resourceBlockId, long companyId, long groupId, String name, OrderByComparator<ResourceBlock> orderByComparator) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.findByPrimaryKey(resourceBlockId);
        Session session = null;
        try {
            session = this.openSession();
            ResourceBlock[] array = new ResourceBlockImpl[]{this.getByC_G_N_PrevAndNext(session, resourceBlock, companyId, groupId, name, orderByComparator, true), resourceBlock, this.getByC_G_N_PrevAndNext(session, resourceBlock, companyId, groupId, name, orderByComparator, false)};
            ResourceBlock[] resourceBlockArray = array;
            return resourceBlockArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ResourceBlock getByC_G_N_PrevAndNext(Session session, ResourceBlock resourceBlock, long companyId, long groupId, String name, OrderByComparator<ResourceBlock> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_RESOURCEBLOCK_WHERE);
        query.append("resourceBlock.companyId = ? AND ");
        query.append("resourceBlock.groupId = ? AND ");
        boolean bindName = false;
        if (name == null) {
            query.append("resourceBlock.name IS NULL");
        } else if (name.equals("")) {
            query.append("(resourceBlock.name IS NULL OR resourceBlock.name = '')");
        } else {
            bindName = true;
            query.append("resourceBlock.name = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY resourceBlock.resourceBlockId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        qPos.add(groupId);
        if (bindName) {
            qPos.add(name);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)resourceBlock)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ResourceBlock)list.get(1);
        }
        return null;
    }

    public void removeByC_G_N(long companyId, long groupId, String name) {
        for (ResourceBlock resourceBlock : this.findByC_G_N(companyId, groupId, name, -1, -1, null)) {
            this.remove((BaseModel)resourceBlock);
        }
    }

    public int countByC_G_N(long companyId, long groupId, String name) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_G_N;
        Object[] finderArgs = new Object[]{companyId, groupId, name};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_RESOURCEBLOCK_WHERE);
            query.append("resourceBlock.companyId = ? AND ");
            query.append("resourceBlock.groupId = ? AND ");
            boolean bindName = false;
            if (name == null) {
                query.append("resourceBlock.name IS NULL");
            } else if (name.equals("")) {
                query.append("(resourceBlock.name IS NULL OR resourceBlock.name = '')");
            } else {
                bindName = true;
                query.append("resourceBlock.name = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e2) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ResourceBlock findByC_G_N_P(long companyId, long groupId, String name, String permissionsHash) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.fetchByC_G_N_P(companyId, groupId, name, permissionsHash);
        if (resourceBlock == null) {
            StringBundler msg = new StringBundler(10);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append(", permissionsHash=");
            msg.append(permissionsHash);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchResourceBlockException(msg.toString());
        }
        return resourceBlock;
    }

    public ResourceBlock fetchByC_G_N_P(long companyId, long groupId, String name, String permissionsHash) {
        return this.fetchByC_G_N_P(companyId, groupId, name, permissionsHash, true);
    }

    public ResourceBlock fetchByC_G_N_P(long companyId, long groupId, String name, String permissionsHash, boolean retrieveFromCache) {
        ResourceBlock resourceBlock;
        Object[] finderArgs = new Object[]{companyId, groupId, name, permissionsHash};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_C_G_N_P, finderArgs, (BasePersistenceImpl)this);
        }
        if (!(!(result instanceof ResourceBlock) || companyId == (resourceBlock = (ResourceBlock)result).getCompanyId() && groupId == resourceBlock.getGroupId() && Objects.equals(name, resourceBlock.getName()) && Objects.equals(permissionsHash, resourceBlock.getPermissionsHash()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(6);
            query.append(_SQL_SELECT_RESOURCEBLOCK_WHERE);
            query.append("resourceBlock.companyId = ? AND ");
            query.append("resourceBlock.groupId = ? AND ");
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_C_G_N_P_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_C_G_N_P_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_C_G_N_P_NAME_2);
            }
            boolean bindPermissionsHash = false;
            if (permissionsHash == null) {
                query.append(_FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_1);
            } else if (permissionsHash.equals("")) {
                query.append(_FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_3);
            } else {
                bindPermissionsHash = true;
                query.append(_FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if (bindPermissionsHash) {
                    qPos.add(permissionsHash);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_G_N_P, finderArgs, (Object)list);
                } else {
                    ResourceBlock resourceBlock2 = (ResourceBlock)list.get(0);
                    result = resourceBlock2;
                    this.cacheResult(resourceBlock2);
                    if (resourceBlock2.getCompanyId() != companyId || resourceBlock2.getGroupId() != groupId || resourceBlock2.getName() == null || !resourceBlock2.getName().equals(name) || resourceBlock2.getPermissionsHash() == null || !resourceBlock2.getPermissionsHash().equals(permissionsHash)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_G_N_P, finderArgs, (Object)resourceBlock2);
                    }
                }
            }
            catch (Exception e2) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_G_N_P, finderArgs);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ResourceBlock)result;
    }

    public ResourceBlock removeByC_G_N_P(long companyId, long groupId, String name, String permissionsHash) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.findByC_G_N_P(companyId, groupId, name, permissionsHash);
        return (ResourceBlock)this.remove((BaseModel)resourceBlock);
    }

    public int countByC_G_N_P(long companyId, long groupId, String name, String permissionsHash) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_G_N_P;
        Object[] finderArgs = new Object[]{companyId, groupId, name, permissionsHash};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_RESOURCEBLOCK_WHERE);
            query.append("resourceBlock.companyId = ? AND ");
            query.append("resourceBlock.groupId = ? AND ");
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_C_G_N_P_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_C_G_N_P_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_C_G_N_P_NAME_2);
            }
            boolean bindPermissionsHash = false;
            if (permissionsHash == null) {
                query.append(_FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_1);
            } else if (permissionsHash.equals("")) {
                query.append(_FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_3);
            } else {
                bindPermissionsHash = true;
                query.append(_FINDER_COLUMN_C_G_N_P_PERMISSIONSHASH_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if (bindPermissionsHash) {
                    qPos.add(permissionsHash);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e2) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ResourceBlockPersistenceImpl() {
        this.setModelClass(ResourceBlock.class);
    }

    public void cacheResult(ResourceBlock resourceBlock) {
        this.entityCache.putResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, (Serializable)Long.valueOf(resourceBlock.getPrimaryKey()), (Serializable)resourceBlock);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_G_N_P, new Object[]{resourceBlock.getCompanyId(), resourceBlock.getGroupId(), resourceBlock.getName(), resourceBlock.getPermissionsHash()}, (Object)resourceBlock);
        resourceBlock.resetOriginalValues();
    }

    public void cacheResult(List<ResourceBlock> resourceBlocks) {
        for (ResourceBlock resourceBlock : resourceBlocks) {
            if (this.entityCache.getResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, (Serializable)Long.valueOf(resourceBlock.getPrimaryKey())) == null) {
                this.cacheResult(resourceBlock);
                continue;
            }
            resourceBlock.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ResourceBlockImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ResourceBlock resourceBlock) {
        this.entityCache.removeResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, (Serializable)Long.valueOf(resourceBlock.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ResourceBlockModelImpl)resourceBlock);
    }

    public void clearCache(List<ResourceBlock> resourceBlocks) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ResourceBlock resourceBlock : resourceBlocks) {
            this.entityCache.removeResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, (Serializable)Long.valueOf(resourceBlock.getPrimaryKey()));
            this.clearUniqueFindersCache((ResourceBlockModelImpl)resourceBlock);
        }
    }

    protected void cacheUniqueFindersCache(ResourceBlockModelImpl resourceBlockModelImpl, boolean isNew) {
        if (isNew) {
            Object[] args = new Object[]{resourceBlockModelImpl.getCompanyId(), resourceBlockModelImpl.getGroupId(), resourceBlockModelImpl.getName(), resourceBlockModelImpl.getPermissionsHash()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_C_G_N_P, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_G_N_P, args, (Object)resourceBlockModelImpl);
        } else if ((resourceBlockModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_G_N_P.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{resourceBlockModelImpl.getCompanyId(), resourceBlockModelImpl.getGroupId(), resourceBlockModelImpl.getName(), resourceBlockModelImpl.getPermissionsHash()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_C_G_N_P, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_G_N_P, args, (Object)resourceBlockModelImpl);
        }
    }

    protected void clearUniqueFindersCache(ResourceBlockModelImpl resourceBlockModelImpl) {
        Object[] args = new Object[]{resourceBlockModelImpl.getCompanyId(), resourceBlockModelImpl.getGroupId(), resourceBlockModelImpl.getName(), resourceBlockModelImpl.getPermissionsHash()};
        this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_G_N_P, args);
        this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_G_N_P, args);
        if ((resourceBlockModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_G_N_P.getColumnBitmask()) != 0L) {
            args = new Object[]{resourceBlockModelImpl.getOriginalCompanyId(), resourceBlockModelImpl.getOriginalGroupId(), resourceBlockModelImpl.getOriginalName(), resourceBlockModelImpl.getOriginalPermissionsHash()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_G_N_P, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_G_N_P, args);
        }
    }

    public ResourceBlock create(long resourceBlockId) {
        ResourceBlockImpl resourceBlock = new ResourceBlockImpl();
        resourceBlock.setNew(true);
        resourceBlock.setPrimaryKey(resourceBlockId);
        resourceBlock.setCompanyId(this.companyProvider.getCompanyId());
        return resourceBlock;
    }

    public ResourceBlock remove(long resourceBlockId) throws NoSuchResourceBlockException {
        return this.remove(Long.valueOf(resourceBlockId));
    }

    public ResourceBlock remove(Serializable primaryKey) throws NoSuchResourceBlockException {
        Session session = null;
        try {
            session = this.openSession();
            ResourceBlock resourceBlock = (ResourceBlock)session.get(ResourceBlockImpl.class, primaryKey);
            if (resourceBlock == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchResourceBlockException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ResourceBlock resourceBlock2 = (ResourceBlock)this.remove((BaseModel)resourceBlock);
            return resourceBlock2;
        }
        catch (NoSuchResourceBlockException nsee) {
            throw nsee;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ResourceBlock removeImpl(ResourceBlock resourceBlock) {
        resourceBlock = this.toUnwrappedModel(resourceBlock);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)resourceBlock)) {
                resourceBlock = (ResourceBlock)session.get(ResourceBlockImpl.class, resourceBlock.getPrimaryKeyObj());
            }
            if (resourceBlock != null) {
                session.delete((Object)resourceBlock);
            }
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
        if (resourceBlock != null) {
            this.clearCache(resourceBlock);
        }
        return resourceBlock;
    }

    public ResourceBlock updateImpl(ResourceBlock resourceBlock) {
        resourceBlock = this.toUnwrappedModel(resourceBlock);
        boolean isNew = resourceBlock.isNew();
        ResourceBlockModelImpl resourceBlockModelImpl = (ResourceBlockModelImpl)resourceBlock;
        Session session = null;
        try {
            session = this.openSession();
            if (resourceBlock.isNew()) {
                session.save((Object)resourceBlock);
                resourceBlock.setNew(false);
            } else {
                resourceBlock = (ResourceBlock)session.merge((Object)resourceBlock);
            }
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !ResourceBlockModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((resourceBlockModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_N.getColumnBitmask()) != 0L) {
                args = new Object[]{resourceBlockModelImpl.getOriginalCompanyId(), resourceBlockModelImpl.getOriginalName()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_N, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_N, args);
                args = new Object[]{resourceBlockModelImpl.getCompanyId(), resourceBlockModelImpl.getName()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_N, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_N, args);
            }
            if ((resourceBlockModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_G_N.getColumnBitmask()) != 0L) {
                args = new Object[]{resourceBlockModelImpl.getOriginalCompanyId(), resourceBlockModelImpl.getOriginalGroupId(), resourceBlockModelImpl.getOriginalName()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_G_N, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_G_N, args);
                args = new Object[]{resourceBlockModelImpl.getCompanyId(), resourceBlockModelImpl.getGroupId(), resourceBlockModelImpl.getName()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_G_N, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_G_N, args);
            }
        }
        this.entityCache.putResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, (Serializable)Long.valueOf(resourceBlock.getPrimaryKey()), (Serializable)resourceBlock, false);
        this.clearUniqueFindersCache(resourceBlockModelImpl);
        this.cacheUniqueFindersCache(resourceBlockModelImpl, isNew);
        resourceBlock.resetOriginalValues();
        return resourceBlock;
    }

    protected ResourceBlock toUnwrappedModel(ResourceBlock resourceBlock) {
        if (resourceBlock instanceof ResourceBlockImpl) {
            return resourceBlock;
        }
        ResourceBlockImpl resourceBlockImpl = new ResourceBlockImpl();
        resourceBlockImpl.setNew(resourceBlock.isNew());
        resourceBlockImpl.setPrimaryKey(resourceBlock.getPrimaryKey());
        resourceBlockImpl.setMvccVersion(resourceBlock.getMvccVersion());
        resourceBlockImpl.setResourceBlockId(resourceBlock.getResourceBlockId());
        resourceBlockImpl.setCompanyId(resourceBlock.getCompanyId());
        resourceBlockImpl.setGroupId(resourceBlock.getGroupId());
        resourceBlockImpl.setName(resourceBlock.getName());
        resourceBlockImpl.setPermissionsHash(resourceBlock.getPermissionsHash());
        resourceBlockImpl.setReferenceCount(resourceBlock.getReferenceCount());
        return resourceBlockImpl;
    }

    public ResourceBlock findByPrimaryKey(Serializable primaryKey) throws NoSuchResourceBlockException {
        ResourceBlock resourceBlock = this.fetchByPrimaryKey(primaryKey);
        if (resourceBlock == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchResourceBlockException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return resourceBlock;
    }

    public ResourceBlock findByPrimaryKey(long resourceBlockId) throws NoSuchResourceBlockException {
        return this.findByPrimaryKey(Long.valueOf(resourceBlockId));
    }

    public ResourceBlock fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        ResourceBlock resourceBlock = (ResourceBlock)serializable;
        if (resourceBlock == null) {
            Session session = null;
            try {
                session = this.openSession();
                resourceBlock = (ResourceBlock)session.get(ResourceBlockImpl.class, primaryKey);
                if (resourceBlock != null) {
                    this.cacheResult(resourceBlock);
                } else {
                    this.entityCache.putResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e2) {
                this.entityCache.removeResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, primaryKey);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        return resourceBlock;
    }

    public ResourceBlock fetchByPrimaryKey(long resourceBlockId) {
        return this.fetchByPrimaryKey(Long.valueOf(resourceBlockId));
    }

    public Map<Serializable, ResourceBlock> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, ResourceBlock> map = new HashMap<Serializable, ResourceBlock>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            ResourceBlock resourceBlock = this.fetchByPrimaryKey(primaryKey);
            if (resourceBlock != null) {
                map.put(primaryKey, resourceBlock);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            Serializable serializable = this.entityCache.getResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, primaryKey);
            if (serializable == nullModel) continue;
            if (serializable == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(primaryKey);
                continue;
            }
            map.put(primaryKey, (ResourceBlock)serializable);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_RESOURCEBLOCK_WHERE_PKS_IN);
        for (Serializable primaryKey : uncachedPrimaryKeys) {
            query.append(String.valueOf(primaryKey));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            for (ResourceBlock resourceBlock : q.list()) {
                map.put(resourceBlock.getPrimaryKeyObj(), resourceBlock);
                this.cacheResult(resourceBlock);
                uncachedPrimaryKeys.remove(resourceBlock.getPrimaryKeyObj());
            }
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                this.entityCache.putResult(ResourceBlockModelImpl.ENTITY_CACHE_ENABLED, ResourceBlockImpl.class, primaryKey, (Serializable)nullModel);
            }
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<ResourceBlock> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ResourceBlock> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ResourceBlock> findAll(int start, int end, OrderByComparator<ResourceBlock> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ResourceBlock> findAll(int start, int end, OrderByComparator<ResourceBlock> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_RESOURCEBLOCK);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_RESOURCEBLOCK;
                if (pagination) {
                    sql = sql.concat(" ORDER BY resourceBlock.resourceBlockId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e2) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ResourceBlock resourceBlock : this.findAll()) {
            this.remove((BaseModel)resourceBlock);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_RESOURCEBLOCK);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e2) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e2);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ResourceBlockModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(ResourceBlockImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

