/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermission;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.Collection;
import java.util.List;
import javax.portlet.PortletMode;

public class PortletPermissionImpl
implements PortletPermission {
    private static final boolean _CHECK_STAGING_PERMISSION_DEFAULT = true;
    private static final boolean _STRICT_DEFAULT = false;
    private static final Log _log = LogFactoryUtil.getLog(PortletPermissionImpl.class);

    public void check(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, 0L, layout, portletId, actionId, false)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portletId, actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId, boolean strict) throws PortalException {
        if (!this.contains(permissionChecker, 0L, layout, portletId, actionId, strict)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portletId, actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, groupId, layout, portletId, actionId, false)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portletId, actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict) throws PortalException {
        this.check(permissionChecker, groupId, layout, portletId, actionId, strict, true);
    }

    public void check(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict, boolean checkStagingPermission) throws PortalException {
        if (!this.contains(permissionChecker, groupId, layout, portletId, actionId, strict, checkStagingPermission)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portletId, actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId) throws PortalException {
        this.check(permissionChecker, groupId, plid, portletId, actionId, false);
    }

    public void check(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId, boolean strict) throws PortalException {
        if (!this.contains(permissionChecker, groupId, plid, portletId, actionId, strict)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portletId, actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long plid, String portletId, String actionId) throws PortalException {
        this.check(permissionChecker, plid, portletId, actionId, false);
    }

    public void check(PermissionChecker permissionChecker, long plid, String portletId, String actionId, boolean strict) throws PortalException {
        if (!this.contains(permissionChecker, plid, portletId, actionId, strict)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portletId, actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, String portletId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, portletId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portletId, actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, Portlet portlet, String actionId) throws PortalException {
        return this.contains(permissionChecker, layout, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, Portlet portlet, String actionId, boolean strict) throws PortalException {
        return this.contains(permissionChecker, 0L, layout, portlet, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException {
        return this.contains(permissionChecker, layout, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId, boolean strict) throws PortalException {
        return this.contains(permissionChecker, 0L, layout, portletId, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, Portlet portlet, String actionId) throws PortalException {
        return this.contains(permissionChecker, groupId, layout, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, Portlet portlet, String actionId, boolean strict) throws PortalException {
        if (portlet.isUndeployedPortlet()) {
            return false;
        }
        return this.contains(permissionChecker, groupId, layout, portlet.getPortletId(), actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId) throws PortalException {
        return this.contains(permissionChecker, groupId, layout, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict) throws PortalException {
        return this.contains(permissionChecker, groupId, layout, portletId, actionId, strict, true);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict, boolean checkStagingPermission) throws PortalException {
        Boolean hasPermission;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)permissionChecker.getCompanyId(), (String)portletId);
        if (portlet == null || portlet.isUndeployedPortlet()) {
            return false;
        }
        String name = null;
        String resourcePermissionPrimKey = null;
        if (layout == null) {
            name = portletId;
            resourcePermissionPrimKey = portletId;
            return permissionChecker.hasPermission(groupId, name, resourcePermissionPrimKey, actionId);
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group == null) {
            group = layout.getGroup();
            groupId = layout.getGroupId();
        }
        if ((group.isControlPanel() || layout.isTypeControlPanel()) && actionId.equals("VIEW")) {
            return true;
        }
        if (layout instanceof VirtualLayout) {
            if (layout.isCustomizable() && !actionId.equals("VIEW")) {
                if (actionId.equals("ADD_TO_PAGE")) {
                    return this.hasAddToPagePermission(permissionChecker, layout, portletId, actionId);
                }
                return this.hasCustomizePermission(permissionChecker, layout, portletId, actionId);
            }
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getSourceLayout();
        }
        if (!group.isLayoutSetPrototype() && actionId.equals("CONFIGURATION") && !SitesUtil.isLayoutUpdateable((Layout)layout)) {
            return false;
        }
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        if (checkStagingPermission && (hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)groupId, (String)rootPortletId, (long)groupId, (String)rootPortletId, (String)actionId)) != null) {
            return hasPermission;
        }
        resourcePermissionPrimKey = this.getPrimaryKey(layout.getPlid(), portletId);
        if (strict) {
            return permissionChecker.hasPermission(groupId, rootPortletId, resourcePermissionPrimKey, actionId);
        }
        if (this.hasConfigurePermission(permissionChecker, layout, portletId, actionId) || this.hasCustomizePermission(permissionChecker, layout, portletId, actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(groupId, rootPortletId, resourcePermissionPrimKey, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, Portlet portlet, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, groupId, layout, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, Portlet portlet, String actionId, boolean strict) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, groupId, layout, portlet, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, groupId, layout, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId, boolean strict) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, groupId, layout, portletId, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, Portlet portlet, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, layout, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, Portlet portlet, String actionId, boolean strict) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, 0L, layout, portlet, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String portletId, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, layout, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String portletId, String actionId, boolean strict) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, 0L, layout, portletId, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, String portletId, String actionId) throws PortalException {
        return this.contains(permissionChecker, 0L, portletId, actionId);
    }

    public String getPrimaryKey(long plid, String portletId) {
        return String.valueOf(plid).concat("_LAYOUT_").concat(portletId);
    }

    public boolean hasAccessPermission(PermissionChecker permissionChecker, long scopeGroupId, Layout layout, Portlet portlet, PortletMode portletMode) throws PortalException {
        boolean access;
        String category;
        if (layout != null && layout.isTypeControlPanel() && StringUtil.startsWith((String)(category = portlet.getControlPanelEntryCategory()), (String)"site_administration.")) {
            layout = null;
        }
        if ((access = this.contains(permissionChecker, scopeGroupId, layout, portlet, "VIEW")) && portletMode.equals((Object)PortletMode.EDIT)) {
            access = this.contains(permissionChecker, scopeGroupId, layout, portlet, "PREFERENCES");
        }
        return access;
    }

    public boolean hasConfigurationPermission(PermissionChecker permissionChecker, long groupId, Layout layout, String actionId) throws PortalException {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (Portlet portlet : layoutTypePortlet.getAllPortlets(false)) {
            if (this.contains(permissionChecker, groupId, layout, portlet.getPortletId(), actionId)) {
                return true;
            }
            if (!this.contains(permissionChecker, groupId, null, portlet.getRootPortletId(), actionId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasControlPanelAccessPermission(PermissionChecker permissionChecker, long groupId, Collection<Portlet> portlets) throws PortalException {
        for (Portlet portlet : portlets) {
            if (!this.hasControlPanelAccessPermission(permissionChecker, groupId, portlet)) continue;
            return true;
        }
        return false;
    }

    public boolean hasControlPanelAccessPermission(PermissionChecker permissionChecker, long scopeGroupId, Portlet portlet) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
        ControlPanelEntry controlPanelEntry = portlet.getControlPanelEntryInstance();
        try {
            return controlPanelEntry.hasAccessPermission(permissionChecker, group, portlet);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Cannot process control panel access permission", (Throwable)e2);
            }
            return false;
        }
    }

    public boolean hasControlPanelAccessPermission(PermissionChecker permissionChecker, long scopeGroupId, String portletId) throws PortalException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
        return this.hasControlPanelAccessPermission(permissionChecker, scopeGroupId, portlet);
    }

    public boolean hasLayoutManagerPermission(String portletId, String actionId) {
        try {
            portletId = PortletConstants.getRootPortletId((String)portletId);
            List layoutManagerActions = ResourceActionsUtil.getPortletResourceLayoutManagerActions((String)portletId);
            return layoutManagerActions.contains(actionId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return false;
        }
    }

    protected boolean hasAddToPagePermission(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException {
        if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE")) {
            return this.contains(permissionChecker, portletId, "ADD_TO_PAGE");
        }
        return false;
    }

    protected boolean hasConfigurePermission(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException {
        if (!(actionId.equals("CONFIGURATION") || actionId.equals("PREFERENCES") || actionId.equals("GUEST_PREFERENCES"))) {
            return false;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        if (portlet.isPreferencesUniquePerLayout()) {
            return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CONFIGURE_PORTLETS");
        }
        return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (String)"CONFIGURE_PORTLETS");
    }

    protected boolean hasCustomizePermission(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (layoutTypePortlet.isCustomizedView() && layoutTypePortlet.isPortletCustomizable(portletId) && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE")) {
            Portlet portlet;
            if (actionId.equals("VIEW")) {
                return true;
            }
            if (actionId.equals("CONFIGURATION") && ((portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId)).isInstanceable() || portlet.isPreferencesUniquePerLayout())) {
                return true;
            }
        }
        return false;
    }
}

