/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermission;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.util.PropsValues;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portal.kernel.model.Group"})
public class GroupPermissionImpl
implements BaseModelPermissionChecker,
GroupPermission {
    public void check(PermissionChecker permissionChecker, Group group, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, group, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), group.getGroupId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), groupId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), Long.valueOf(0L).longValue(), new String[]{actionId});
        }
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, primaryKey, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, Group group, String actionId) throws PortalException {
        if ((actionId.equals("ADD_LAYOUT") || actionId.equals("MANAGE_LAYOUTS")) && (group.hasLocalOrRemoteStagingGroup() && PropsValues.STAGING_LIVE_GROUP_LOCKING_ENABLED || group.isLayoutPrototype())) {
            return false;
        }
        long groupId = group.getGroupId();
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isUser()) {
            User user = UserLocalServiceUtil.getUserById((long)group.getClassPK());
            if (permissionChecker.getUserId() != user.getUserId() && UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (long[])user.getOrganizationIds(), (String)"UPDATE")) {
                return true;
            }
        }
        if (actionId.equals("ADD_COMMUNITY") && (permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_SUBGROUPS") || PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_COMMUNITY"))) {
            return true;
        }
        if (actionId.equals("ADD_LAYOUT") && permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_LAYOUTS")) {
            return true;
        }
        if ((actionId.equals("EXPORT_IMPORT_LAYOUTS") || actionId.equals("EXPORT_IMPORT_PORTLET_INFO") || actionId.equals("PUBLISH_PORTLET_INFO")) && permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "PUBLISH_STAGING")) {
            return true;
        }
        if (actionId.equals("VIEW") && (permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "ASSIGN_USER_ROLES") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_LAYOUTS"))) {
            return true;
        }
        if (actionId.equals("VIEW_STAGING") && (permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_LAYOUTS") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_STAGING") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "PUBLISH_STAGING") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "UPDATE"))) {
            return true;
        }
        if (permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, actionId)) {
            return true;
        }
        while (!group.isRoot()) {
            if (this.contains(permissionChecker, group.getParentGroupId(), "MANAGE_SUBGROUPS")) {
                return true;
            }
            group = group.getParentGroup();
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (groupId > 0L) {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            return this.contains(permissionChecker, group, actionId);
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, String actionId) {
        return permissionChecker.hasPermission(0L, Group.class.getName(), Group.class.getName(), actionId);
    }
}

